% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_module.R
\name{MP modules}
\alias{MP modules}
\alias{mpParamsSetterUI}
\alias{mpParamsSetterServer}
\alias{mp_params_switcheroo}
\title{mpParamsSetterUI}
\usage{
mpParamsSetterUI(
  id,
  mp_visible = NULL,
  title = "Select the type of HCR you want to test.",
  init_thresh_max_catch = 140,
  init_thresh_belbow = 0.5,
  init_constant_catch = 50,
  init_constant_effort = 1
)

mpParamsSetterServer(id, get_stoch_params = NULL)

mp_params_switcheroo(input, est_sigma = 0, est_bias = 0)
}
\arguments{
\item{id}{The id (shiny magic)}

\item{mp_visible}{Which HCR types to show.}

\item{title}{The title.}

\item{init_thresh_max_catch}{Initial value of the maximum catch for the catch threshold HCR.}

\item{init_thresh_belbow}{Initial value of the belbow for the catch threshold HCR.}

\item{init_constant_catch}{Initial value of constant catch for the constant catch HCR.}

\item{init_constant_effort}{Initial value of constant effort for the constant effort HCR.}

\item{get_stoch_params}{Reactive expression that gets the parameters from the stochasticity setter. Otherwise est_sigma and est_bias are set to 0.}

\item{input}{List of information taken from the Shiny UI (mpParamsSetterUI)}

\item{est_sigma}{Standard deviation of the estimation variability (default = 0).}

\item{est_bias}{Estimation bias as a proportion. Can be negative (default = 0).}
}
\value{
A taglist

A list of HCR options.
}
\description{
The interface for the HCR options.
The parameter selection inputs shown in the app are conditional on the selected type of HCR.
Some of the inputs have initial values that can be set using the function arguments.

Does the setting part of the MP params module.
Returns a list of MP params based on the MP inputs.

Creates the MP params list based on the MP selection from the Shiny UI.
Defined outside of a reactive environment above so we can use it non-reactively (helpful for testing).
}
