% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{show.simulation}
\alias{show.simulation}
\title{Show simulation object}
\usage{
show.simulation(object)
}
\arguments{
\item{object}{an S4 object of class \code{simulation}}
}
\value{
Show a list of important parameters in class \code{simulation}.
}
\description{
Function to print the \code{simulation} class object after the \code{simulation}
model has been constructed.
}
\examples{
library(AIUQ)

# Simulate simple diffusion for 100 images with 100 by 100 pixels
sim_bm = simulation(sz=100,len_t=100,sigma_bm=0.5)
show(sim_bm)
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
