% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{fit_models}
\alias{fit_models}
\title{Fit PERMANOVA models and arrange by AICc}
\usage{
fit_models(
  all_forms,
  veg_data,
  env_data,
  method = "bray",
  ncores = 2,
  log = TRUE,
  logfile = "log.txt",
  multiple = 100,
  strata = NULL,
  verbose = FALSE
)
}
\arguments{
\item{all_forms}{A data frame generated by \code{\link{make_models}}}

\item{veg_data}{A dataset with vegetation presence absense or abundance data}

\item{env_data}{A dataset with the variables described in all_froms}

\item{method}{method for distance from \code{\link{vegdist}}}

\item{ncores}{An integer specifying the number of cores to use for parallel processing}

\item{log}{logical if true, a log file will be generated}

\item{logfile}{the text file that will be generated as a log}

\item{multiple}{after how many loops to write a log file}

\item{strata}{a block variable similar to the use in \code{\link{adonis2}}}

\item{verbose}{logical, defaults TRUE, sends messages about processing times}
}
\value{
A data.frame with fitted models arranged by AICc, including the formula used, the number of
explanatory variables, R2, adjusted R2, and the AICc and max VIF.
}
\description{
This function fits PERMANOVA models for all combinations of variables in a given dataset, and arranges the models by Akaike Information Criterion (AICc) score. The function also calculates the maximum variance inflation factor (max_vif) for each model.
}
\examples{

\donttest{
library(vegan)
data(dune)
data(dune.env)

AllModels <- make_models(vars = c("A1", "Moisture", "Manure"))

fit_models(all_forms = AllModels,
           veg_data = dune,
           env_data = dune.env)
}

}
\references{
Anderson, M. J. (2001). A new method for non-parametric multivariate analysis of variance. Austral Ecology, 26(1), 32-46.
https://doi.org/10.1111/j.1442-9993.2001.01070.pp.x
}
