% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{ACF}
\alias{ACF}
\title{Autocorrelation function}
\usage{
ACF(
  x,
  lag.max = NULL,
  type = c("correlation", "covariance", "partial"),
  plot = TRUE,
  na.action = na.contiguous,
  demean = TRUE,
  ...
)
}
\arguments{
\item{x}{time-series vector}

\item{lag.max}{maximum lag at which to calculate the ACF}

\item{type}{character string giving the type of ACF to be computed}

\item{plot}{logical}

\item{na.action}{function to be called to handle missing values. na.pass can be used}

\item{demean}{logical}

\item{...}{other arguments}
}
\value{
An object returns a graph with the x-axis of lags and y-axis of autocorrelation functions.
A text gives a hint how to read a graph.
}
\description{
Autocorrelation function demonstrates correlation between stationary time series and its lagged values
}
\references{
Gilbert, P.,  Plummer, M., Ripley, B.D., Auto- and Cross- Covariance and -Correlation Function Estimation
Dancho, Matt. Published 2021-01-18. timetk package
}
