% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{shrinkByKappa}
\alias{shrinkByKappa}
\title{Calculate conditions numbers for signature subsets}
\usage{
shrinkByKappa(
  sigMatrix,
  numChunks = NULL,
  verbose = TRUE,
  plotIt = TRUE,
  singleCore = FALSE,
  fastStop = TRUE
)
}
\arguments{
\item{sigMatrix}{The original signature matrix}

\item{numChunks}{The number of groups of genes to remove (DEFAULT: NULL)}

\item{verbose}{Print out the current chunk as is it's being calculated (DEFAULT: NULL)}

\item{plotIt}{The title of the plot (DEFAULT: TRUE)}

\item{singleCore}{Set to FALSE to use multiple cores to calculate condition numbers (DEFAULT: FALSE)}

\item{fastStop}{Halt early when the condition number changes by less than 1 for 3 iterations (DEFAULT: FALSE)}
}
\value{
A list with condition numbers and gene lists
}
\description{
Remove genes by chunks by picking those the most improve the condition number.  
Will set any infinite condition numbers to max(kappas[!is.infinite(kappas)])+1
Return the condition numbers with their gene lists
}
\examples{
library(ADAPTS)
LM22 <- ADAPTS::LM22
sigGenesList <- shrinkByKappa(sigMatrix=LM22[1:100,1:5], numChunks=4, 
verbose=FALSE, plotIt=FALSE, singleCore=TRUE, fastStop=TRUE)

}
