% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Agent.R
\name{Agent}
\alias{Agent}
\title{R6 class that represent an agent}
\description{
The key task of an agent is to maintain events, and handle them in the
chronological order. Agents also maintain their states, which is a list of
values. The events, when handled, operate on the state of the agent (or other
agents).
}
\details{
During the simulation the agent with the earliest event in the simulation is
picked out, unscheduled, then its earliest event is handled, which
potentially causes the state change of the agent (or another agent in the
simulation). The state change is then logged by loggers that recognize the
state change.

An agent itself cannot handle the event. Instead, it has to be added to a
simulation (or a population that itself is added to a simulation).
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{state}}{Get/set the state of the agent}

\item{\code{id}}{Get the agent ID}

\item{\code{get}}{Get the external pointer for the agent}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-R6Agent-new}{\code{Agent$new()}}
\item \href{#method-R6Agent-match}{\code{Agent$match()}}
\item \href{#method-R6Agent-schedule}{\code{Agent$schedule()}}
\item \href{#method-R6Agent-unschedule}{\code{Agent$unschedule()}}
\item \href{#method-R6Agent-clone}{\code{Agent$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Agent-new"></a>}}
\if{latex}{\out{\hypertarget{method-R6Agent-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$new(agent = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent}}{can be either an external pointer to an agent such as one
returned by newAgent, or a list representing the initial state for creating
a new agent, or NULL (an empty state)
Check if the state of the agent matches a given state}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Agent-match"></a>}}
\if{latex}{\out{\hypertarget{method-R6Agent-match}{}}}
\subsection{Method \code{match()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$match(rule)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rule}}{the state to match, a list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a logical value
Schedule an event
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Agent-schedule"></a>}}
\if{latex}{\out{\hypertarget{method-R6Agent-schedule}{}}}
\subsection{Method \code{schedule()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$schedule(event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{an object of the R6 class Event, or an external pointer
returned by newEvent}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the agent itself
Unschedule an event
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Agent-unschedule"></a>}}
\if{latex}{\out{\hypertarget{method-R6Agent-unschedule}{}}}
\subsection{Method \code{unschedule()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$unschedule(event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{an object of the R6 class Event, or an external pointer
returned by newEvent}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the agent itself
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-R6Agent-clone"></a>}}
\if{latex}{\out{\hypertarget{method-R6Agent-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
