% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{md_bullet}
\alias{md_bullet}
\title{Markdown bullet point list}
\usage{
md_bullet(
  x,
  indent = 0,
  code = FALSE,
  italic = FALSE,
  marker = c("*", "-", "+")
)
}
\arguments{
\item{x}{character (vector). Text to convert into a bullet point list.}

\item{indent}{numeric, positive whole number. Number of spaces to indent the
bullet point list by (Default: 0).}

\item{code}{logical. If the text will be formatted as code (Default: TRUE).}

\item{italic}{logical. If the text will be formatted as italic
(Default: FALSE).}

\item{marker}{character. The bullet list marker to use (Default: "*").}
}
\value{
\code{glue} vector. A bullet point list in markdown format.
}
\description{
Creates a bullet point list in markdown format. Copy of
\code{gluedown::md_bullet()} but with the added ability to specify an indent to
create nested lists and the option to use code font.
}
\examples{
md_bullet(c("First item", "Second item", "Third item"), code = TRUE)

md_bullet(c("First item", "Second item", "Third item"), indent = 2)
}
