% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newick_to_Af.R
\name{newick_to_Af}
\alias{newick_to_Af}
\title{Converts files with phylogenetic trees in newick format into an AntibodyForests object.}
\usage{
newick_to_Af(file.list, file.dir)
}
\arguments{
\item{file.list}{list - list of newick files to be converted to AntibodyForests object. Could be a named list where the names correspond to sample IDs.}

\item{file.dir}{directory - directory where the newick files are stored. If provided, the function will read all newick files in the directory.}
}
\value{
AntibodyForests object
}
\description{
Converts files with phylogenetic trees in newick format into an AntibodyForests object. Make sure that the germline node is called "germline" and that every line represents a new tree in the newick file. All trees in the same file should be from the same sample.
}
\examples{
\dontrun{
af <- newick_to_Af(file.list = list("S1" = "path/to/sample1.nwk", "S2" = "path/to/sample2.nwk"))
}
}
