% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pattern_recognition_distances.R
\name{DEcort}
\alias{DEcort}
\title{Distance based on value and behavior of the time series}
\usage{
DEcort(k, S1, S2)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{S1}{A vector representing a univariate time series}

\item{S2}{A second vector representing a univariate time series}
}
\value{
a non-zero value
}
\description{
Return a weighted distance based on a weighted sum of the Euclidean norm
and the temporal correlation coefficient. The distance is inflated in the
presence of NA compensating for the lack of information.
}
\examples{
S1=rnorm(100)
S2=rnorm(100)
k=1
DEcort(k,S1, S2)
}
\seealso{
Douzal-Chouakria, Ahlame, and Cecile Amblard. "Classification
Trees for Time Series." Pattern Recognition 45, no. 3 (March 2012):
1076-91. \doi{10.1016/j.patcog.2011.08.018}
}
