% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences_to_long.R
\name{sequences_to_long}
\alias{sequences_to_long}
\title{Convert Sequences to Long Format}
\usage{
sequences_to_long(
  sequences,
  sequence = "sequence",
  start_time = NULL,
  end_time = NULL,
  covariates = NULL
)
}
\arguments{
\item{sequences}{A data frame containing sequences.}

\item{sequence}{Column name with the sequences.}

\item{start_time}{Column name with the start time. Defaults to NULL.}

\item{end_time}{Column name with the end time. Defaults to NULL.}

\item{covariates}{A vector with column names of the covariates. Defaults to NULL.}
}
\value{
A data frame in long format with sequences, start time, end time, duration, and covariates.
}
\description{
This function converts a data frame with sequences into long format. It expands each sequence into individual rows, optionally including start and end times and covariates.
}
\examples{
sequences <- data.frame(sequence = c('A B C', 'A B', 'A C', 'B C'),
                        covariate1 = c('X', 'Y', 'X', 'Y'),
                        covariate2 = c('M', 'N', 'M', 'N'))
sequences_to_long(sequences,
                  sequence = 'sequence',
                  covariates = c('covariate1', 'covariate2'))
}
