% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_position.R
\name{element_position}
\alias{element_position}
\title{Calculate Median Position of Each Element in Sequences}
\usage{
element_position(sequences, n_permutations = 1000)
}
\arguments{
\item{sequences}{A character vector of sequences to analyze.}

\item{n_permutations}{The number of permutations to use for the null distribution.}
}
\value{
A data frame with the median position, standard deviation, expected position, effect size, and p-value for each element.
}
\description{
This function calculates the median position of each element across sequences,
summarizes the distribution, and compares it to a shuffled distribution.
}
\examples{
# Example usage:
sequences <- c("A B C", "A B", "A C", "B C", "A B C D")
result <- element_position(sequences)
print(result)
}
