% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{instant_p.val}
\alias{instant_p.val}
\title{P-values for instantaneous graph}
\usage{
instant_p.val(lin.anc)
}
\arguments{
\item{lin.anc}{output from AncReg()}
}
\value{
A numeric matrix of p-values for the instantaneous graph
}
\description{
Collect p-values for instantaneous graph.
}
\examples{
# random DAGS for simulation
set.seed(1234)

p <- 5 #number of nodes
DAG <- pcalg::randomDAG(p, prob = 0.5)

B <- matrix(0, p, p) # represent DAG as matrix
for (i in 2:p){
  for(j in 1:(i-1)){
    # store edge weights
    B[i,j] <- max(0, DAG@edgeData@data[[paste(j,"|",i, sep="")]]$weight)
  }
}
colnames(B) <- rownames(B) <- LETTERS[1:p]

# solution in terms of noise
Bprime <- MASS::ginv(diag(p) - B)

n <- 500
N <- matrix(rexp(n * p), ncol = p)
X <- t(Bprime \%*\% t(N))
colnames(X) <- LETTERS[1:p]

# fit ancestor regression
fit <- AncReg(X)

# collect instantaneous p-values
instant_p.val(fit)
}
\seealso{
\code{\link{AncReg}}
}
