% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSset.R
\name{NSset}
\alias{NSset}
\title{Vertices and visualization of the NS set}
\usage{
NSset(
  c,
  draw = FALSE,
  dimension = NULL,
  representation = "projection",
  col = NULL,
  agents_names = NULL,
  labels = TRUE
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{draw}{A logical value indicating whether the plot should be generated. By default, \code{draw = FALSE}.}

\item{dimension}{A character string that specifies the dimension of the graphic. Possible values are \code{"1D"}, \code{"2D"}, and \code{"3D"}.
By default, the dimension is chosen based on the number of agents: \code{"1D"} for 2 agents, \code{"2D"} for 3 agents, and \code{"3D"} for 4 agents.}

\item{representation}{A character string indicating which NS set is displayed. Possible values are \code{"real"}, \code{"projection"}, and \code{"both"}. By default, \code{representation = "projection"}.}

\item{col}{A character string reflecting the color tone of the NS set. By default, the color tone \code{"dodgerblue"} is used.}

\item{agents_names}{A vector defining the name assigned to each agent. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the coordinates of the points and the plot title should be displayed. By default, \code{labels = TRUE}.}
}
\value{
A numeric matrix containing the vertices that determine the NS set.
Additionally, if \code{draw = TRUE} and the number of agents is 2, 3, or 4, a plot displaying the faces and extreme points of the NS set will be generated.
}
\description{
\code{NSset} calculates the coordinates of the vertices that make up the NS set.
It also enables the generation of a graphical representation of the no-subsidy set in 1D, 2D, and 3D (available only when there are 2, 3, or 4 agents).
}
\details{
For each \eqn{c\in C^N} let \eqn{H(c)=\{x\in\mathbb{R}:x(N)=c_n\}} be the hyperplane of \eqn{\mathbb{R}^N}
given by all the vectors whose coordinates add up to \eqn{c_n}. A cost allocation for \eqn{c\in C^N} is a vector
\eqn{x\in H(c)} such that \eqn{0\leq x\leq c}. The component \eqn{x_i} is the contribution requested from agent \eqn{i}.
Let \eqn{X(c)} be the set of cost allocations for \eqn{c\in C^N}. Given \eqn{x\in X(c)}, the difference \eqn{c_i-x_I} is the
benefit of agent \eqn{i} at \eqn{x}.

A basic requirement is that at an allocation \eqn{x\in X(c)} on group \eqn{N'\subset N}
of agents would subsidize the other agents by contributing more than what the group would have to pay on its own. The no-subsidy constraint
for the group \eqn{N'\subset N} is \eqn{x(N')\geq \text{max}\{c_j:j\in N'\}}. The set of cost allocations for \eqn{c\in C^N} that satisfy the no-subsidy
constraints, the no-subsidy set for short, is given by:
\deqn{
NS(c)=\{x\in X(c):x(N')\leq\text{max}\{c_j:j\in N'\}, \;\text{for all}\; N'\subset N\}}
\deqn{= \{x\in \mathbb{R}^N:x\geq 0, \ x(N)=c_n, \ x_1+\dots+x_i\leq c_i,\;\text{for all}\;i\in N\backslash \{n\}\}
}
Thus, the no-subsidy correspondence NS assigns to each \eqn{c\in C^N} the set \eqn{NS(c)}.

Nevertheless, when a problem has group of cloned agents, the structure of its no-subsidy set is simpler than
when all the cost parameters are different. Let \eqn{t\in N}, \eqn{\mathcal{A}_t^N} be the set of pairs \eqn{(\eta,c)\in \mathbb{N}^t\times\mathbb{R}^t} and \eqn{N_s^{\eta}=N_s^{\eta\ast c}=\{j\in N:(n\ast c)_j=c_s\}}.
Then the no subsidy set for \eqn{\eta\ast c \in C^N} is:
\deqn{
NS(\eta\ast c)=\{x\in\mathbb{R}:x\geq 0,\ x(N)=c_t,\ x(N_1^{\eta})+\dots+x(N^{\eta}_s)\leq c_s, \;\text{for all}\; s<t\}.
}
For any cost vector \eqn{c}, if there are \eqn{n} agents with different cost parameters, the number of faces is \eqn{2n-2}.
However, the number of full-dimensional faces is indeed affected by the presence of clones. Let \eqn{t\in N}, \eqn{(\eta,c)\in\mathcal{A}^N_t}, and
\eqn{\eta\ast c \in C^N}, \eqn{\text{NS}(\eta\ast c)} has \eqn{n+t-2} full-dimensional faces if \eqn{\eta_t=1} and \eqn{n+t-1} full-dimensional faces otherwise.
On the other hand, the number of different extreme points of the set \eqn{\text{NS}(\eta\ast c)} is: \eqn{\eta_t \prod_{i \in T \setminus \{t\}} (\eta_i + 1)}
(so, when there are no clones, the \eqn{\text{NS}(c)} has \eqn{2^{n-1}} extreme points).
}
\examples{
# Projected NS set for 3 agents
c <- c(5, 10, 20) # Cost vector
NSset(c, draw = TRUE)

# Real and projected NS set for 3 agents
c <- c(1, 2, 3) # Cost vector
NSset(c, TRUE, "3D", "both")

# Projected NS set for 4 agents
c <- c(3, 3, 3, 10) # Cost vector
NSset(c, TRUE, "3D", "projection", "aquamarine",
c("Alex", "Estela", "Carmen", "Miguel"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

González-Díaz, J., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2016). Airport games: the core and its center. \emph{Mathematical Social Sciences}, 82, 105–115.

Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2020). The boundary of the core of a balanced game: faces games.
\emph{International Journal of Game Theory}, 49(2), 579-599.
}
\seealso{
\code{\link{plotallocations}}, \code{\link{NScheck}}, \code{\link{NSfaces}}, \code{\link{NSstructure}}
}
