% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_arrange.R
\name{monitor_arrange}
\alias{monitor_arrange}
\title{Order \emph{mts_monitor} time series by metadata values}
\usage{
monitor_arrange(monitor, ...)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{...}{variables in \code{mts$meta}.}
}
\value{
A reordered version of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
The variable(s) in \code{...} are used to specify columns of
\code{monitor$meta} to use for ordering. Under the hood, this
function uses \code{\link[dplyr]{arrange}} on \code{monitor$meta} and then
reorders \code{monitor$data} to match.
}
\examples{
library(AirMonitor)

Camp_Fire$meta$elevation[1:10]

byElevation <-
  Camp_Fire \%>\%
  monitor_arrange(elevation)

byElevation$meta$elevation[1:10]

}
\seealso{
\link{monitor_select}
}
