% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markblue.R
\name{markblue}
\alias{markblue}
\title{Spray deposit (glowing blue marker)}
\usage{
markblue(
  d1,
  d2,
  vl,
  ci,
  ncu2 = 1,
  ntrat2 = 2,
  nrep2 = 3,
  nresp2 = 5,
  naf2 = 6,
  analysis = TRUE,
  design = "DIC",
  transf = 1,
  quali = TRUE,
  grau = 1,
  test = "parametric",
  mcomp = "tukey",
  ylab = expression(mu ~ cm^2),
  save.xlsx = FALSE
)
}
\arguments{
\item{d1}{Curved worksheet}

\item{d2}{Experiment worksheet}

\item{vl}{Wash volume (mL)}

\item{ci}{Initial marker concentration}

\item{ncu2}{Column referring to the curve (\emph{default} is 1)}

\item{ntrat2}{Column referring to treatment}

\item{nrep2}{Column referring to repetition}

\item{nresp2}{Column referring to absorbance}

\item{naf2}{Sheet area (cm2)}

\item{analysis}{Perform statistical analysis}

\item{design}{Experiment design}

\item{transf}{Data transformation}

\item{quali}{Qualitative or quantitative treatment (\emph{default} is TRUE)}

\item{grau}{degree of the polynomial (when treatment is quantitative)}

\item{test}{Parametric or Nonparametric (\emph{default} is "parametric")}

\item{mcomp}{Mean comparison test (\emph{default} is "tukey")}

\item{ylab}{y axis name (\emph{default} is expression(mu~cm^2))}

\item{save.xlsx}{Want to export in excel format (\emph{default} is FALSE)}
}
\value{
Returns the comparison between the treatments of the experiment
}
\description{
This is a function to determine spray deposit using bright blue marker and then after performing tests of assumptions, analysis of variance and comparison of means
}
\note{
Curve name on the curve worksheet (d1) must be the same as the curve name on the experiment worksheet (d2)
}
\examples{
data("example_markbluecurve")
data("example_markblue")
markblue(d1=example_markbluecurve,
         d2=example_markblue,
         vl=20,
         ci=1500,
         ncu2 = 1,
         ntrat2 = 2,
         nrep2 = 3,
         nresp2 = 4,
         naf2 = 5)
}
\references{
No reference
}
\seealso{
\link{markmet}
}
\author{
Rodrigo Yudi Palhaci Marubayashi, \email{marubayashi@uel.br}

Gabriel Danilo Shimizu

Otavio Jorge Grigoli Abi Saab
}
