% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aggregate.R
\name{Aggregate}
\alias{Aggregate}
\title{Aggregate numeric, Date and categorical variables}
\usage{
Aggregate(
  x,
  by,
  end_ind = Sys.Date(),
  format = "\%Y-\%m-\%d",
  tibble = FALSE,
  verbose = TRUE,
  object = NULL,
  p = "all"
)
}
\arguments{
\item{x}{A data frame or data table. Categorical variables have to be of type character or factor and continuous variables have to be of type integer or numeric. Date variables should be in the Date format.}

\item{by}{A character string specifying the variable on which to aggregate the results. Note that 'by' should be a variable of the table 'x'.}

\item{end_ind}{A Date object, or something which can be coerced by \code{as.Date(origin, ...)} to such an object. If not specified,  we take the \code{Sys.Date()} as end date.}

\item{format}{A character string. If not specified, the ISO 8601 international standard which expresses a day "\%Y-\%m-\%d" is taken.}

\item{tibble}{Should the output be a tibble, data frame or data table? By default, the function returns a data frame or data table depending on the input. To return a tibble, the user must set the tibble = TRUE.}

\item{verbose}{indicator Used to show the progress.}

\item{object}{Parameter related to the \code{dummy} function. See ?\code{dummy} for more information.}

\item{p}{Parameter related to the \code{dummy} function. See ?\code{dummy} for more information.}
}
\value{
A data frame, data table or tibble with the aforementioned variables aggregated by the given ID variables. If the input is a data frame, a data frame is returned else a data table is returned.
}
\description{
The \code{Aggregate} function (not to be confounded with aggregate) prepares a data frame or data table for merging by computing the sum, mean and variance of all continuous (integer and numeric) variables by a given variable. For all categorical variabes (character and factor), it creates dummies and subsequently computes the sum and the mode by a given variable. For all Date variables, it computes the recency and duration by a given variable with repsect the an end date variable. For computational speed, all the calculations are done with \code{data.table}. This functions aims at maximum information extraction with a minimum amount of code.
}
\examples{
# Example
# Create some data
data <- data.frame(V1=sample(as.factor(c('yes','no')), 200000, TRUE),
                  V2=sample(as.character(c(1,2,3,4,5)),200000, TRUE),
                  V3=sample(1:20000,200000, TRUE),
                  V4=sample(300:1000, 200000, TRUE),
                  V5 = sample(as.Date(as.Date('2014-12-09'):Sys.Date()-1,
                  origin = "1970-01-01"),200000,TRUE),
                  ID=sample(x = as.character(1:4), size = 200000, replace = TRUE))

Aggregate(x=data,by='ID')

# Examples of how to use the object and p argument. See dummy and categories function for details.
# Aggregate(x=data,by='ID',object=categories(data))
# Aggregate(x=data,by='ID',p=2)
}
\author{
Authors: Matthias Bogaert, Michel Ballings, Dirk Van den Poel, Maintainer: \email{matthias.bogaert@UGent.be}
}
