% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeasonalityScore.r
\name{getSeasonalityScore}
\alias{getSeasonalityScore}
\title{Get the seasonality score for a given monthly time series}
\usage{
getSeasonalityScore(tsData)
}
\arguments{
\item{tsData}{A time series object.}
}
\value{
A numeric value between 0 and 1 (inclusive) representing the seasonality of a time series.
}
\description{
The seasonality score of a monthly time series is computed as its departure from a uniform distribution.
}
\details{
The degree of seasonality of a monthly time series is based on its departure from a uniform distribution.
If the number of cases for a given concept is uniformly distributed across all time periods (in this case, all months), 
then its monthly proportion would be approximately constant.  In this case, the time series would be
considered "strictly non-seasonal" and its "seasonality score" would be zero.
Similarly, if all cases recur at a single point in time (that is, in a single month), such a time series would be considered
"strictly seasonal" and its seasonality score would be 1.  All other time series would have
a seasonality score between 0 and 1.  Currently, only monthly time series are supported.
}
