% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\docType{data}
\name{ofp}
\alias{ofp}
\title{Number of physician office visits.}
\format{
The original data set is based on the work of Deb and Trivedi (1997) analyze data on 4406 individuals, aged 66 and over, who are covered
by Medicare, a public insurance program. Originally obtained from the US National Medical
Expenditure Survey (NMES) for 1987/88, the data are available from the data archive of
the Journal of Applied Econometrics at http://www.econ.queensu.ca/jae/1997-v12.3/deb-trivedi/.
In AZIAD package we work with the number of physicians office visits for the patients.Based on
the analysis of kstest.A and kstest.B and lrt.A the data belongs to zero-inflated beta negative binomial
or beta negative binomial hurdle model.
}
\source{
\itemize{\item http://www.jstatsoft.org/v27/i08/paper}
}
\usage{
ofp
}
\description{
A data set containing ofp (number of physician office visit) of 4406 individuals.
}
\examples{
ofp
set.seed(1008)
\donttest{d1=kstest.A(ofp,nsim=200,bootstrap=TRUE,dist="geometric")}
\donttest{d2=kstest.A(ofp,nsim=200,bootstrap=TRUE,dist="zibnb")}
\donttest{lrt.A(d1,d2)}       #0
}
\references{
\itemize{\item Zeileis, A. and Kleiber, C. and Jackma, S. (2008). "Regression Models for Count Data in R". JSS 27, 8, 1–25.}
}
\keyword{datasets}
