% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat124}
\alias{simDat124}
\title{Simulate data for Chapter 12.4: Counts with offsets}
\usage{
simDat124(nSites = 50, alpha = log(2), beta = log(5) - log(2))
}
\arguments{
\item{nSites}{Number of sites}

\item{alpha}{Intercept}

\item{beta}{Slope for land use}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Number of sites}
  \item{alpha}{Intercept}
  \item{beta}{Slope for land use}
  \item{A}{Site areas}
  \item{C}{Simulated hare counts}
}
\description{
Generate counts of hares in two landuse types 
when study area size A varies and is used as an offset
}
\examples{
str(dat <- simDat124())      # Implicit default arguments
str(dat <- simDat124(nSites = 1000, beta = 0)) # "Model-of-the-mean" without effect of landuse
str(dat <- simDat124(nSites = 100, alpha = log(2), beta = -2)) # Grassland better than arable

}
\author{
Marc Kéry
}
