% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{sample_recordings}
\alias{sample_recordings}
\title{Sample recordings}
\usage{
sample_recordings(
  meta_weights,
  n,
  os = NULL,
  col_site_id = site_id,
  col_sel_weights = psel_std,
  seed = NULL,
  ...
)
}
\arguments{
\item{meta_weights}{(Spatial) Data frame. Recording meta data selection
weights. Output of \code{calc_selection_weights()}. Must have at least the
columns identified by \code{col_site_id} and \code{col_sel_weights}, as well as the
probability of selection columns (those starting with \code{psel}) and \code{doy}.}

\item{n}{Numeric, Data frame, Vector, or List. Number of base samples to
choose. For stratification by site, a named vector/list of samples per site, or
a data frame with columns \code{n} for samples, \code{n_os} for oversamples and the
column matching that identified by \code{col_site_id}.}

\item{os}{Numeric, Vector, or List. Over sample size (proportional) or named
vector/list of number of samples per site Ignored if \code{n} is a data
frame.}

\item{col_site_id}{Column. Unquoted column containing site strata IDs
(defaults to \code{site_id}).}

\item{col_sel_weights}{Column. Unquoted name of column identifying selection
weights (defaults to \code{psel_std})}

\item{seed}{Numeric. Random seed to use for random sampling. Seed only
applies to specific sampling events (does not change seed in the
environment). \code{NULL} does not set a seed.}

\item{...}{Extra named arguments passed on to \code{spsurvey::grts()}.}
}
\value{
A sampling run from grts. Note that the included dataset is spatial,
but is a dummy spatial dataset created by using dates and times to create
the spatial landscape.
}
\description{
Sample recordings based on selection weights from \code{calc_selection_weights()}
using \code{spsurvey::grts()}.
}
\examples{
s <- clean_site_index(example_sites_clean,
  name_date_time = c("date_time_start", "date_time_end")
)
m <- clean_metadata(project_files = example_files) |>
  add_sites(s) |>
  calc_sun()

params <- sim_selection_weights()
w <- calc_selection_weights(m, params = params)

# No stratification by site
samples <- sample_recordings(w, n = 10, os = 0.1, col_site_id = NULL)

# Stratification by site defined by...

# lists
samples <- sample_recordings(w, n = list(P01_1 = 2, P02_1 = 5, P03_1 = 2), os = 0.2)

# vectors
samples <- sample_recordings(w, n = c(P01_1 = 2, P02_1 = 5, P03_1 = 2), os = 0.2)

# data frame
samples <- sample_recordings(
  w,
  n = data.frame(
    site_id = c("P01_1", "P02_1", "P03_1"),
    n = c(2, 5, 2),
    n_os = c(0, 0, 1)
  )
)

}
