% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_simulate_offspring.R
\name{simulate_offspring}
\alias{simulate_offspring}
\title{Simulate offspring}
\usage{
simulate_offspring(
  sire_genotype,
  dam_genotype,
  number_offspring,
  ploidy_level = 2,
  sire_contribution = 1,
  dam_contribution = 1,
  recombination_rate = 0.5,
  genotyping_error = 0.01
)
}
\arguments{
\item{sire_genotype}{sire genotype}

\item{dam_genotype}{dam genotype}

\item{number_offspring}{number of offspring to simulate}

\item{ploidy_level}{ploidy level of offspring}

\item{sire_contribution}{sire contribution}

\item{dam_contribution}{dam contribution}

\item{recombination_rate}{recombination rate (only important for tri/tetra ploids offspring)}

\item{genotyping_error}{genotyping error}
}
\value{
list with matrix with simulated offspring and pedigree
}
\description{
Simulate offspring
}
\examples{
data("APIS_sire")
data("APIS_dam")

# For diploide offspring
simulate_offspring(sire_genotype=APIS_sire, dam_genotype=APIS_dam,
                   number_offspring=10,
                   ploidy_level = 2,
                   sire_contribution = 1, dam_contribution = 1,
                   recombination_rate = 0.5,
                   genotyping_error = 0.01)

# For triploide offspring
simulate_offspring(sire_genotype=APIS_sire, dam_genotype=APIS_dam,
                   number_offspring=10,
                   ploidy_level = 3,
                   sire_contribution = 1, dam_contribution = 2,
                   recombination_rate = 0.5,
                   genotyping_error = 0.01)

}
