% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainEffect.R
\name{maineffect}
\alias{maineffect}
\title{Estimate age effect and period effect}
\usage{
maineffect(A, P, C, model = temp6, data, gee = FALSE, ...)
}
\arguments{
\item{A, P, C}{The numbers of age groups, period groups, and cohort groups separately.}

\item{model}{A generalized linear regression model generated from
the internal function temp_model}

\item{data}{A data frame containing the outcome variable, age group
indicator, period group indicator, and covariates to be used in the model.
If the variable(s) are not found in data, there will be an error message
reminding the users to check the input data again.}

\item{gee}{Logical, indicating if the data is cross-sectional data or
longitudinal/panel data. If \code{TRUE}, the generalized estimating equation
will be used to correct the standard error estimates. The default is
\code{FALSE}, indicating that the data are cross-sectional.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
A list containing:
\item{intercept}{The overall intercept.}
\item{age_effect}{The estimated age main effect.}
\item{period_effect}{The estimated period main effect.}
}
\description{
Estimate age and period effect from APCI model
}
