% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{apci.plot.raw}
\alias{apci.plot.raw}
\title{Plotting age and period patterns}
\usage{
apci.plot.raw(data, outcome_var, age, period, ...)
}
\arguments{
\item{data}{A data frame containing the outcome variable, age group
indicator, period group indicator, and covariates to be used in the model.
If the variable(s) are not found in data, there will be an error message
reminding the users to check the input data again.}

\item{outcome_var}{An object of class character indicating
the name of the outcome variable used in the model. The
outcome variable can be a continuous, binary, categorical, or count variable.}

\item{age}{An object of class character representing the age group index
taking on a small number of distinct values in the data. Usually, the vector
should be converted to a factor (or the terms of "category" and "enumerated
type").}

\item{period}{An object of class character, similar to the argument of age,
representing the time period index in the data.}

\item{\dots}{Additional arguments to be passed to the function.}
}
\value{
A plot with two panels showing the age and period trends separately.
}
\description{
Visualize the age and period patterns by plotting the
raw scores in each age and period square.
}
\examples{
# load package
library("APCI")
# load data
test_data <- APCI::women9017
test_data$acc <- as.factor(test_data$acc)
test_data$pcc <- as.factor(test_data$pcc)
test_data$educc <- as.factor(test_data$educc)
test_data$educr <- as.factor(test_data$educr)

# fit APC-I model
APC_I <- APCI::apci(outcome = "inlfc",
                    age = "acc",
                    period = "pcc",
                    cohort = "ccc",
                    weight = "wt",
                    data = test_data,dev.test=FALSE,
                    print = TRUE,
                    family = "gaussian")
summary(APC_I)

# plot the raw pattern
apci.plot.raw(data = test_data, outcome_var = "inlfc",age = "acc",
              period = "pcc")
}
