% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_stress_category.R
\name{calc_stress_category}
\alias{calc_stress_category}
\title{Calculate Perceived Stress Category}
\usage{
calc_stress_category(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `stress_category`, where `stress_category` represents the stress level ('Low', 'Moderate', or 'High') for each participant.
Participants who did not answer all 10 questions will have NA values.
}
\description{
This function creates an ordinal categorical variable indicating perceived stress levels as 'Low', 'Moderate', or 'High' based on participants' total perceived stress score.
The perceived stress score is calculated as the sum of individual item scores, with 'Low' for scores 0-13, 'Moderate' for scores 14-26, and 'High' for scores 27-40.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 10),
  question_concept_id = rep(c(40192381, 40192396, 40192419, 40192445,
                              40192449, 40192452, 40192462, 40192491,
                              40192506, 40192525), times = 3),
  answer_concept_id = sample(c(40192465, 40192430, 40192429, 40192477,
                                40192424), 30, replace = TRUE)
)

# Compute perceived stress categories
stress_category_scores <- calc_stress_category(survey_df)
head(stress_category_scores)

}
