% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_social_support.R
\name{calc_social_support}
\alias{calc_social_support}
\title{Calculate Social Support Score}
\usage{
calc_social_support(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `social_support`, where `social_support`
is the calculated social support score for each participant. The score is scaled from 0 to 100, with higher values indicating greater social support.
Participants who did not answer all eight questions will have NA values.
}
\description{
This function computes a numeric social support score ranging from 0 to 100.
The score is based on the mean of individual item scores, transformed to a 0-100 scale, with higher scores indicating more social support.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 8),
  question_concept_id = rep(c(40192388, 40192399, 40192439, 40192442,
                              40192446, 40192480, 40192511, 40192528), times = 3),
  answer_concept_id = sample(c(40192454, 40192518, 40192486, 40192382, 40192521),
                             24, replace = TRUE)
)

# Compute social support scores
social_support_scores <- calc_social_support(survey_df)
head(social_support_scores)

}
