% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_physical_disorder.R
\name{calc_physical_disorder}
\alias{calc_physical_disorder}
\title{Calculate Neighborhood Physical Disorder Score}
\usage{
calc_physical_disorder(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `physical_disorder`, where `physical_disorder` is the average score for neighborhood physical disorder
for each participant. The score is calculated as the mean of six items, with higher values indicating more physical disorder.
Participants who did not answer all six questions will have NA values.
}
\description{
This function computes a numeric score representing the level of physical disorder in a participant's neighborhood.
The score ranges from 1 to 4, with higher scores indicating higher physical disorder, and lower scores indicating better physical order in the neighborhood.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 6),
  question_concept_id = rep(c(40192420, 40192522, 40192412,
                              40192469, 40192456, 40192386), times = 3),
  answer_concept_id = sample(c(40192514, 40192455, 40192408, 40192422),
                             18, replace = TRUE)
)

# Compute neighborhood physical disorder scores
physical_disorder_scores <- calc_physical_disorder(survey_df)
head(physical_disorder_scores)

}
