% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_nei.R
\name{calc_nei}
\alias{calc_nei}
\title{Calculate Neighborhood Environment Index (NEI)}
\usage{
calc_nei(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `nei`, where `nei`
is the calculated Neighborhood Environment Index score for each participant. The score is the sum of individual item scores,
where higher values indicate a more favorable built environment for physical activity. Participants who did not answer all 6 questions will have NA values.
}
\description{
This function computes a Neighborhood Environment Index (NEI) score based on 6 specific items related to the built environment for physical activity.
The score ranges from 0 to 6, with higher scores indicating a more favorable environment for physical activity.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 6),
  question_concept_id = rep(c(40192410, 40192431, 40192436, 40192437,
                              40192440, 40192458), times = 3),
  answer_concept_id = sample(c(40192527, 40192422, 40192407, 903087,
                                903096, 40192520, 40192514, 40192455),
                             18, replace = TRUE)
)

# Compute Neighborhood Environment Index (NEI) scores
nei_scores <- calc_nei(survey_df)
head(nei_scores)

}
