% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_housing_insecurity.R
\name{calc_housing_insecurity}
\alias{calc_housing_insecurity}
\title{Calculate Housing Insecurity}
\usage{
calc_housing_insecurity(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer`.}
}
\value{
A data frame with two columns: `person_id` and `housing_insecurity`, where `housing_insecurity`
is a TRUE or FALSE indicator for each participant. TRUE indicates housing insecurity (two or more moves in the past year), and FALSE otherwise.
Participants without data will have NA values.
}
\description{
This function creates a binary categorical variable indicating whether a participant is at risk of, or is currently experiencing, housing insecurity.
Housing insecurity is defined as having moved two or more times in the past 12 months.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5),
  question_concept_id = rep(40192441, 5),
  answer = c("0", "1", "2", "3", "Skip")
)

# Compute housing insecurity status
housing_insecurity_scores <- calc_housing_insecurity(survey_df)
head(housing_insecurity_scores)

}
