% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_disorder.R
\name{calc_disorder}
\alias{calc_disorder}
\title{Calculate Neighborhood Disorder Score}
\usage{
calc_disorder(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `disorder`, where `disorder`
is the calculated neighborhood disorder score for each participant. Participants who did not
answer all 13 questions will have an NA score.
}
\description{
This function computes a neighborhood disorder score ranging from 1 to 4 based on
survey responses. The score is the mean of 13 specific item scores, where higher scores
indicate a greater sense of disorder in the neighborhood, and lower scores indicate a sense
of order. Some items are reverse-coded to ensure consistency in interpretation.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 13),
  question_concept_id = rep(c(40192420, 40192522, 40192412, 40192469, 40192456,
                              40192386, 40192500, 40192493, 40192457, 40192476,
                              40192404, 40192400, 40192384), times = 3),
  answer_concept_id = sample(c(40192514, 40192455, 40192408, 40192422),
                      39, replace = TRUE)
)

# Compute neighborhood disorder scores
disorder_scores <- calc_disorder(survey_df)
head(disorder_scores)

}
