% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-package.R
\docType{package}
\name{ANOFA-package}
\alias{ANOFA}
\alias{ANOFA-package}
\title{ANOFA: Analyses of Frequency Data}
\description{
\code{ANOFA} is a library to perform frequency data analyses.
It is based on the G statistics (first developed by Fisher).
This statistics is fully additive and can be decomposed in
main effects and interaction effects, in simple effects in the
decomposition of a significant interaction, in contrasts, etc.
The present library performs these analyses and also can be used
to plan statistical power for the analysis of frequency, obtain
plots of the various effects, etc. It aims at replicating the most
commonly-used ANOVA commands so that using this package should be
easy.

The data supplied to an ANOFA can be in three formats: (i) long format,
(ii) wide format, (iii) compiled format, or (iv) raw format. Check
the \code{anofa} commands for more precision (in what follow, we assume
the compiled format where the frequencies are given in a column name \code{Freq})

The main function is

\code{w <- anofa(formula, data)}

where \code{formula} is a formula giving the factors, e.g., "Freq ~ A * B".

For more details on the underlying math, see \insertCite{lc23b;textual}{ANOFA}.

An omnibus analysis may be followed by simple effects or contrasts analyses:
\code{emFrequencies(w, formula)}
\code{contrast(w, listOfContrasts)}

As usual, the output can be obtained with
\code{print(w) #implicite}
\code{summary(w) # or summarize(w) for the G statistics table}
\code{explain(w) # for human-readable output}

Data format can be converted to other format with
\code{toLong(w)}
\code{toWide(w)}
\code{toCompiled(w)}
\code{toRaw(w)}
\code{toTabulated(w) # the only format that cannot be used as input to anofa}

The package includes additional, helper, functions: \itemize{
\item{\code{powerXXX()}} to compute sample size given effect size;
\item{\code{anofaPlot()}} to obtain a plot of the frequencies with error bars;
\item{\code{effectsizeXXX()}} to compute the effect size;
\item{\code{grf()}} to generate random frequencies from a given design.
}
and example datasets, some described in the article:  \itemize{
\item{\code{LandisBarrettGalvin2013}} illustrates a 5 x 3 design;
\item{\code{LightMargolin1971}} illustrates a 5 x 2 design;
\item{\code{Gillet1993}} illustrates a 2 x 3 x 2 design;
\item{\code{Detergent}} illustrates a 2 x 2 x 2 x 3 design;
}

The functions uses the following options: \itemize{
\item{\code{ANOFA.feedback}} ((currently unused));
\item{\code{ANOFA.digits}} for the number of digits displayed in G statistics tables.
}
}
\details{
ANOFA library for analyses of frequency data
}
\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://dcousin3.github.io/ANOFA/}
  \item Report bugs at \url{https://github.com/dcousin3/ANOFA/issues/}
}

}
\author{
\strong{Maintainer}: Denis Cousineau \email{denis.cousineau@uottawa.ca}

Other contributors:
\itemize{
  \item Louis Laurencelle \email{louis.laurencelle@gmail.com} [contributor]
  \item Pier-Olivier Caron \email{pocaron19@gmail.com} [contributor]
}

}
\keyword{internal}
