% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Getters.R
\docType{methods}
\name{getPosition}
\alias{getPosition}
\alias{getPosition,VoxelSpace,vector-method}
\alias{getPosition,VoxelSpace,matrix-method}
\alias{getPosition,VoxelSpace,data.table-method}
\alias{getPosition,VoxelSpace,missing-method}
\title{Gets the x, y, z coordinates of a given voxel.}
\usage{
getPosition(vxsp, vx)

\S4method{getPosition}{VoxelSpace,vector}(vxsp, vx)

\S4method{getPosition}{VoxelSpace,matrix}(vxsp, vx)

\S4method{getPosition}{VoxelSpace,data.table}(vxsp, vx)

\S4method{getPosition}{VoxelSpace,missing}(vxsp, vx)
}
\arguments{
\item{vxsp}{a \code{\linkS4class{VoxelSpace}} object.}

\item{vx}{(i, j, k) voxel coordinates as a \code{\link[data.table:data.table-class]{data.table::data.table}}
with i, j, k columns, a vector (i, j, k) or a matrix with i, j, k columns.}
}
\value{
the x, y, z coordinates of the voxel center.
}
\description{
Gets the x, y, z coordinates of the voxel center. If the voxel
parameter is missing, it returns the positions of all the voxels in the
voxel space.
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))

# get position of voxel(i=0, j=0, k=0)
getPosition(vxsp, c(0, 0, 0))

# get position of voxels 1 to 10 in the data.table
getPosition(vxsp, vxsp@data[1:10,])

# get positions of every voxel
getPosition(vxsp)
}
