% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_val_split.R
\name{train_val_split_by_AP}
\alias{train_val_split_by_AP}
\title{Train-Validation Split by Accident Period}
\usage{
train_val_split_by_AP(df, accident_periods, max_dev_periods, test = FALSE)
}
\arguments{
\item{df}{Claims Triangle and other information. \code{data.frame} format of
claims and related information for each cell. Dataframe will have columns
\code{origin} and \code{dev} as columns 1 and 2 respectively.}

\item{accident_periods}{Vector of accident periods. Will be equivalent to
\code{1:Triangle_Size}}

\item{max_dev_periods}{Vector of development periods}

\item{test}{Returns the test set if \code{TRUE}}
}
\value{
List containing \verb{$train}, \verb{$valid}, \verb{$test}, which should partition
the input \code{df}.
}
\description{
Function for training/validation splitting.
}
\details{
Assigns training set defined by a maximum development period for each
accident period: \eqn{(x_{ij} <= MaxDP(i))}.

Validation set is therefore cells outside of this period but within the
upper triangle. The test set is all observations in the lower triangle.
}
\examples{
data("test_claims_dataset")

train_val <- train_val_split_by_AP(
    df = test_claims_dataset,
    accident_periods = 1:40,
    max_dev_periods = 40:1,
    test = TRUE
)

}
\seealso{
\link[ADLP]{train_val_split}
}
