% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions.R
\name{adlp_partition}
\alias{adlp_partition}
\alias{adlp_partition_none}
\alias{adlp_partition_ap}
\title{Accident and Development period Adjusted Linear Pools partition function}
\usage{
adlp_partition(df, ...)

adlp_partition_none(df)

adlp_partition_ap(df, tri.size, size = 1, weights = rep(1, size))
}
\arguments{
\item{df}{data.frame format of claims and related information for each cell.
Dataframe will have columns \code{origin} and \code{dev} as columns 1 and 2 respectively.}

\item{...}{Other parameters used to calculate ADLP partitions}

\item{tri.size}{Triangle size in claims}

\item{size}{Number of partitions}

\item{weights}{a vector of weights for the size of each partition.}
}
\value{
List containing the \code{df} as a result of the partitions.
}
\description{
General framework for any user-defined function for partitions of
claims triangle data.
}
\details{
\code{adlp_partition_none} is the default functionality with no partitions. This is
equivalent to the standard linear pooling.

\code{adlp_partition_ap} will partition the claims triangle by accident period,
Where the choice of accident period to partition will be determined to most
closely resemble the desired \code{weights}.

The choice of accident period relies on a greedy algorithm that aims to find the
accident period that provides the amount of cells that is larger or equal to the
desired split.
}
\examples{
data("test_claims_dataset")
adlp_partition_none(test_claims_dataset)

data("test_claims_dataset")
adlp_partition_ap(test_claims_dataset, tri.size = 40, size = 3)

}
\seealso{
\link[ADLP]{adlp_partition_none},
\link[ADLP]{adlp_partition_ap}
}
