% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABSurvTDC.R
\name{CoxPred}
\alias{CoxPred}
\title{ABCoxPH Prediction}
\usage{
CoxPred(Model, NewData, AFC, HYS)
}
\arguments{
\item{Model}{ABCoxPH model}

\item{NewData}{New data}

\item{AFC}{Age (in days) at first calving}

\item{HYS}{Combine effect of herd, year and season}
}
\value{
\itemize{
  \item SurvProb - Survival probabilities
}
}
\description{
Prediction for ABCoxPH model
}
\examples{
library("ABSurvTDC")
library("readxl")
data_test<-read_excel(path = system.file("extdata/data_test.xlsx", package = "ABSurvTDC"))
PropData<-DataPrep(data =as.data.frame(data_test))
model<-ABCoxPH(PropData)
Lact_1<-c("Yes","Yes","Yes","No","No","No","No","No","No","No","No")
Lact_2<-c("No","No","No","No","Yes","Yes","No","No","No","No","No")
Lact_3<-c("No","No","No","No","No","No","No","No","Yes","Yes","Yes")
Lact_4<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_5<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_6<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_7<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_8<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_9<-c("No","No","No","No","No","No","No","No","No","No","No")
ndata<- data.frame(Lact_1,Lact_2,Lact_3,Lact_4,Lact_5,Lact_6,Lact_7,
                   Lact_8,Lact_9)
HYS<-2033
AFC <- 1400
CoxPred(Model=model, NewData=ndata, AFC, HYS)

}
\references{
\itemize{
\item J.D. Kalbfleisch and R.L. Prentice (1980). The statistical analysis of failure time data. John Wiley & Sons, Inc., New York, 1980.  <doi:10.1002/9781118032985>
\item J.P. Klein and  M L. Moeschberger (2003). Survival Analysis: Techniques for Censored and Truncated Data. Springer New York. <doi:10.1007/b97377>
}
}
