/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import weka.classifiers.functions.pace.DiscreteFunction;
import weka.classifiers.functions.pace.PaceMatrix;
import weka.core.RevisionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.IntVector;

public abstract class MixtureDistribution
implements TechnicalInformationHandler,
RevisionHandler {
    protected DiscreteFunction mixingDistribution;
    public static final int NNMMethod = 1;
    public static final int PMMethod = 2;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wang, Y");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.TITLE, "A new approach to fitting linear models in high dimensional spaces");
        result.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Wang, Y. and Witten, I. H.");
        additional.setValue(TechnicalInformation.Field.YEAR, "2002");
        additional.setValue(TechnicalInformation.Field.TITLE, "Modeling for optimal probability prediction");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Nineteenth International Conference in Machine Learning");
        additional.setValue(TechnicalInformation.Field.YEAR, "2002");
        additional.setValue(TechnicalInformation.Field.PAGES, "650-657");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Sydney, Australia");
        return result;
    }

    public DiscreteFunction getMixingDistribution() {
        return this.mixingDistribution;
    }

    public void setMixingDistribution(DiscreteFunction d) {
        this.mixingDistribution = d;
    }

    public void fit(DoubleVector data) {
        this.fit(data, 1);
    }

    public void fit(DoubleVector data, int method) {
        DoubleVector subset;
        DoubleVector data2 = (DoubleVector)data.clone();
        if (data2.unsorted()) {
            data2.sort();
        }
        int n = data2.size();
        int start = 0;
        DiscreteFunction d = new DiscreteFunction();
        int i = 0;
        while (i < n - 1) {
            if (this.separable(data2, start, i, data2.get(i + 1)) && this.separable(data2, i + 1, n - 1, data2.get(i))) {
                subset = data2.subvector(start, i);
                d.plusEquals(this.fitForSingleCluster(subset, method).timesEquals(i - start + 1));
                start = i + 1;
            }
            ++i;
        }
        subset = data2.subvector(start, n - 1);
        d.plusEquals(this.fitForSingleCluster(subset, method).timesEquals(n - start));
        d.sort();
        d.normalize();
        this.mixingDistribution = d;
    }

    public DiscreteFunction fitForSingleCluster(DoubleVector data, int method) {
        DoubleVector weights;
        if (data.size() < 2) {
            return new DiscreteFunction(data);
        }
        DoubleVector sp = this.supportPoints(data, 0);
        PaceMatrix fi = this.fittingIntervals(data);
        PaceMatrix pm = this.probabilityMatrix(sp, fi);
        PaceMatrix epm = new PaceMatrix(this.empiricalProbability(data, fi).timesEquals(1.0 / (double)data.size()));
        IntVector pvt = IntVector.seq(0, sp.size() - 1);
        switch (method) {
            case 1: {
                weights = pm.nnls(epm, pvt);
                break;
            }
            case 2: {
                weights = pm.nnlse1(epm, pvt);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown method");
            }
        }
        DoubleVector sp2 = new DoubleVector(pvt.size());
        int i = 0;
        while (i < sp2.size()) {
            sp2.set(i, sp.get(pvt.get(i)));
            ++i;
        }
        DiscreteFunction d = new DiscreteFunction(sp2, weights);
        d.sort();
        d.normalize();
        return d;
    }

    public abstract boolean separable(DoubleVector var1, int var2, int var3, double var4);

    public abstract DoubleVector supportPoints(DoubleVector var1, int var2);

    public abstract PaceMatrix fittingIntervals(DoubleVector var1);

    public abstract PaceMatrix probabilityMatrix(DoubleVector var1, PaceMatrix var2);

    public PaceMatrix empiricalProbability(DoubleVector data, PaceMatrix intervals) {
        int n = data.size();
        int k = intervals.getRowDimension();
        PaceMatrix epm = new PaceMatrix(k, 1, 0.0);
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < k) {
                double point = 0.0;
                if (intervals.get(i, 0) == data.get(j) || intervals.get(i, 1) == data.get(j)) {
                    point = 0.5;
                } else if (intervals.get(i, 0) < data.get(j) && intervals.get(i, 1) > data.get(j)) {
                    point = 1.0;
                }
                epm.setPlus(i, 0, point);
                ++i;
            }
            ++j;
        }
        return epm;
    }

    public String toString() {
        return "The mixing distribution:\n" + this.mixingDistribution.toString();
    }
}

