/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.delta;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.view.GraphView;
import org.chocosolver.solver.variables.view.delta.GraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.directed.DirectedGraphUnionView;
import org.chocosolver.solver.variables.view.graph.undirected.UndirectedGraphUnionView;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class GraphUnionViewDeltaMonitor
extends GraphViewDeltaMonitor {
    GraphView<?, ?> g;
    ISet[] nodesAdded;
    ISet[][] edgesAdded;
    ISet[] nodesRemoved;
    ISet[][] edgesRemoved;
    ISet addedNode;
    ISet addNode;
    ISet removeNode;
    ISet[] addedEdge;
    ISet[] addEdge;
    ISet[] removeEdge;

    public GraphUnionViewDeltaMonitor(GraphView<?, ?> graphUnionView, IGraphDeltaMonitor ... deltaMonitors) {
        super(deltaMonitors);
        int i;
        assert (graphUnionView instanceof UndirectedGraphUnionView || graphUnionView instanceof DirectedGraphUnionView);
        this.g = graphUnionView;
        this.nodesAdded = new ISet[deltaMonitors.length];
        this.nodesRemoved = new ISet[deltaMonitors.length];
        for (i = 0; i < deltaMonitors.length; ++i) {
            this.nodesAdded[i] = SetFactory.makeSmallBipartiteSet();
            this.nodesRemoved[i] = SetFactory.makeSmallBipartiteSet();
        }
        this.addedNode = SetFactory.makeStoredSet(SetType.BITSET, 0, this.g.getModel());
        this.addNode = new SetDifference(new SetUnion(this.nodesAdded), this.addedNode);
        this.removeNode = new SetUnion(this.nodesRemoved);
        this.edgesAdded = new ISet[this.g.getNbMaxNodes()][];
        this.edgesRemoved = new ISet[this.g.getNbMaxNodes()][];
        for (i = 0; i < this.g.getNbMaxNodes(); ++i) {
            this.edgesAdded[i] = new ISet[deltaMonitors.length];
            this.edgesRemoved[i] = new ISet[deltaMonitors.length];
            for (int j = 0; j < deltaMonitors.length; ++j) {
                this.edgesAdded[i][j] = SetFactory.makeSmallBipartiteSet();
                this.edgesRemoved[i][j] = SetFactory.makeSmallBipartiteSet();
            }
        }
        this.addedEdge = new ISet[this.g.getNbMaxNodes()];
        this.addEdge = new ISet[this.g.getNbMaxNodes()];
        this.removeEdge = new ISet[this.g.getNbMaxNodes()];
        for (i = 0; i < this.g.getNbMaxNodes(); ++i) {
            this.addedEdge[i] = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.g.getModel());
            this.addEdge[i] = new SetDifference(new SetUnion(this.edgesAdded[i]), this.addedEdge[i]);
            this.removeEdge[i] = new SetUnion(this.edgesRemoved[i]);
        }
    }

    protected void fillAddNodes() throws ContradictionException {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            int finalI = i;
            this.nodesAdded[i].clear();
            this.deltaMonitors[i].forEachNode(x -> this.nodesAdded[finalI].add(x), GraphEventType.ADD_NODE);
        }
    }

    protected void fillRemoveNodes() throws ContradictionException {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            int finalI = i;
            this.nodesRemoved[i].clear();
            this.deltaMonitors[i].forEachNode(x -> this.nodesRemoved[finalI].add(x), GraphEventType.REMOVE_NODE);
        }
    }

    protected void fillAddEdges() throws ContradictionException {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            int finalI = i;
            for (int j = 0; j < this.g.getNbMaxNodes(); ++j) {
                this.edgesAdded[j][i].clear();
            }
            this.deltaMonitors[i].forEachEdge((from, to) -> this.edgesAdded[from][finalI].add(to), GraphEventType.ADD_EDGE);
        }
    }

    protected void fillRemoveEdges() throws ContradictionException {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            int finalI = i;
            for (int j = 0; j < this.g.getNbMaxNodes(); ++j) {
                this.edgesRemoved[j][i].clear();
            }
            this.deltaMonitors[i].forEachEdge((from, to) -> this.edgesRemoved[from][finalI].add(to), GraphEventType.REMOVE_EDGE);
        }
    }

    @Override
    public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
        block4: {
            block3: {
                int v;
                if (evt != GraphEventType.ADD_NODE) break block3;
                this.fillAddNodes();
                ISetIterator iSetIterator = this.addNode.iterator();
                while (iSetIterator.hasNext()) {
                    v = (Integer)iSetIterator.next();
                    proc.execute(v);
                }
                iSetIterator = this.addNode.iterator();
                while (iSetIterator.hasNext()) {
                    v = (Integer)iSetIterator.next();
                    this.addedNode.add(v);
                }
                break block4;
            }
            if (evt != GraphEventType.REMOVE_NODE) break block4;
            this.fillRemoveNodes();
            ISetIterator iSetIterator = this.removeNode.iterator();
            while (iSetIterator.hasNext()) {
                int v = (Integer)iSetIterator.next();
                if (this.g.getPotentialNodes().contains(v)) continue;
                proc.execute(v);
            }
        }
    }

    @Override
    public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
        block6: {
            block5: {
                if (evt != GraphEventType.ADD_EDGE) break block5;
                this.fillAddEdges();
                for (int from = 0; from < this.g.getNbMaxNodes(); ++from) {
                    int to;
                    ISetIterator iSetIterator = this.addEdge[from].iterator();
                    while (iSetIterator.hasNext()) {
                        to = (Integer)iSetIterator.next();
                        proc.execute(from, to);
                    }
                    iSetIterator = this.addEdge[from].iterator();
                    while (iSetIterator.hasNext()) {
                        to = (Integer)iSetIterator.next();
                        this.addedEdge[from].add(to);
                    }
                }
                break block6;
            }
            if (evt != GraphEventType.REMOVE_EDGE) break block6;
            this.fillRemoveEdges();
            for (int from = 0; from < this.g.getNbMaxNodes(); ++from) {
                ISetIterator iSetIterator = this.removeEdge[from].iterator();
                while (iSetIterator.hasNext()) {
                    int to = (Integer)iSetIterator.next();
                    if (this.g.getUB().containsEdge(from, to)) continue;
                    proc.execute(from, to);
                }
            }
        }
    }
}

