## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-micro-fit-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input options' and 'Fitting options' boxes in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-micronuclei-fit-01.png")

## ----sc-micro-fit-02, echo=FALSE, out.width='75%', fig.align='center', fig.cap="'Data input' box in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-micronuclei-fit-02.png")

## ----micro-count-data, tidy=TRUE, tidy.opts=list(width.cutoff=60)-------------
count_data <- system.file("extdata", "count-data-mayakannan-2018.csv", package = "biodosetools") %>%
  utils::read.csv() %>%
  calculate_aberr_table(type = "count", assessment_u = 1)

## -----------------------------------------------------------------------------
count_data

## ----sc-micro-fit-03, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Irradiation conditions' box in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-micronuclei-fit-03.png")

## ----sc-micro-fit-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Export results' boxes in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-micronuclei-fit-04.png")

## ----micro-fit-results--------------------------------------------------------
fit_results <- fit(
  count_data = count_data,
  model_formula = "lin-quad",
  model_family = "quasipoisson",
  fit_link = "identity",
  aberr_module = "micronuclei"
)

## -----------------------------------------------------------------------------
names(fit_results)

## ----micro-fit-coeffs-r-------------------------------------------------------
fit_results$fit_coeffs

## ----micro-fit-dose-curve, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plot of dose-effect curve generated by \\{biodosetools\\}. The grey shading indicates the uncertainties associated with the calibration curve."----
plot_fit_dose_curve(
  fit_results,
  aberr_name = "Micronuclei",
  place = "UI"
)

