/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeIndividual;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.ExprTreeSpecies;
import net.sourceforge.jclec.exprtree.IPrimitive;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ExprTreeIndividualSpecies
extends ExprTreeSpecies
implements IConfigure {
    private static final long serialVersionUID = -5304951511814536309L;

    public ExprTreeIndividualSpecies() {
        this.genotypeSchema = new ExprTreeSchema();
    }

    public void setMinTreeSize(int minimumTreeSize) {
        this.genotypeSchema.setMinTreeSize(minimumTreeSize);
    }

    public void setMaxTreeSize(int maximumTreeSize) {
        this.genotypeSchema.setMaxTreeSize(maximumTreeSize);
    }

    public void setRootType(Class<?> rootType) {
        this.genotypeSchema.setRootType(rootType);
    }

    public void setTerminals(IPrimitive[] terminals) {
        this.genotypeSchema.setTerminals(terminals);
    }

    public void setFunctions(IPrimitive[] functions) {
        this.genotypeSchema.setFunctions(functions);
    }

    public ExprTreeIndividual createIndividual() {
        return new ExprTreeIndividual();
    }

    @Override
    public ExprTreeIndividual createIndividual(ExprTree genotype) {
        return new ExprTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        String header = "expression-tree";
        int minTreeSize = settings.getInt(String.valueOf(header) + ".min-tree-size");
        this.setMinTreeSize(minTreeSize);
        int maxTreeSize = settings.getInt(String.valueOf(header) + ".max-tree-size");
        this.setMaxTreeSize(maxTreeSize);
        String rootTypeName = settings.getString(String.valueOf(header) + ".root-type");
        try {
            Class<?> rootType = Class.forName(rootTypeName);
            this.setRootType(rootType);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("");
        }
        int numberOfTerminals = settings.getList(String.valueOf(header) + ".terminals.terminal[@class]").size();
        IPrimitive[] terminals = new IPrimitive[numberOfTerminals];
        int j = 0;
        while (j < numberOfTerminals) {
            try {
                String terminalClassname = settings.getString(String.valueOf(header) + ".terminals.terminal(" + j + ")[@class]");
                Class<?> terminalClass = Class.forName(terminalClassname);
                terminals[j] = (IPrimitive)terminalClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException();
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException();
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException();
            }
            ++j;
        }
        this.setTerminals(terminals);
        int numberOfFunctions = settings.getList(String.valueOf(header) + ".functions.function[@class]").size();
        IPrimitive[] functions = new IPrimitive[numberOfFunctions];
        int j2 = 0;
        while (j2 < numberOfFunctions) {
            try {
                String functionClassname = settings.getString(String.valueOf(header) + ".functions.function(" + j2 + ")[@class]");
                Class<?> functionClass = Class.forName(functionClassname);
                functions[j2] = (IPrimitive)functionClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException();
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException();
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException();
            }
            ++j2;
        }
        this.setFunctions(functions);
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTreeIndividualSpecies) {
            ExprTreeIndividualSpecies cother = (ExprTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

