/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ICompositeModel;
import ec.tstoolkit.ssf.ISsf;

public class SsfComposite
implements ISsf {
    private final ICompositeModel model_;
    private final int[] m_dim;
    private final int[] m_cdim;
    private final int m_fdim;
    private final double[] tmp_;

    public SsfComposite(ICompositeModel model) {
        this.model_ = model;
        int n = this.model_.getComponentsCount();
        this.m_dim = new int[n];
        this.m_cdim = new int[n];
        this.m_dim[0] = this.model_.getComponent(0).getStateDim();
        for (int i = 1; i < this.m_dim.length; ++i) {
            this.m_dim[i] = this.model_.getComponent(i).getStateDim();
            this.m_cdim[i] = this.m_cdim[i - 1] + this.m_dim[i - 1];
        }
        this.m_fdim = this.m_cdim[n - 1] + this.m_dim[n - 1];
        this.tmp_ = new double[this.m_fdim];
    }

    public ICompositeModel getCompositeModel() {
        return this.model_;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        DataBlock tmp = new DataBlock(this.tmp_);
        tmp.set(0.0);
        this.Z(pos, tmp);
        DataBlockIterator cols = lm.columns();
        DataBlock col = cols.getData();
        do {
            double z = -tmp.get(cols.getPosition());
            col.addAY(z, k);
        } while (cols.next());
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        DataBlock tmp = new DataBlock(this.tmp_);
        tmp.set(0.0);
        this.Z(pos, tmp);
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            col.addAY(d * tmp.get(cols.getPosition()), tmp);
        } while (cols.next());
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        for (int i = 0; i < this.m_dim.length; ++i) {
            DataBlock xi = this.sub(i, x);
            double h = this.model_.getWeight(i, pos);
            if (h == 0.0) continue;
            this.model_.getComponent(i).XpZd(pos, xi, d * h);
        }
    }

    @Override
    public void Z(int pos, DataBlock x) {
        for (int i = 0; i < this.m_dim.length; ++i) {
            DataBlock xi = this.sub(i, x);
            double h = this.model_.getWeight(i, pos);
            if (h == 0.0) continue;
            this.model_.getComponent(i).Z(pos, xi);
            xi.mul(h);
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        DataBlock tmp = new DataBlock(x.getLength());
        boolean ok = false;
        for (int i = 0; i < this.m_dim.length; ++i) {
            double h = this.model_.getWeight(i, pos);
            if (h == 0.0) continue;
            if (!ok) {
                this.model_.getComponent(i).ZM(pos, this.rsub(i, m), x);
                x.mul(h);
                ok = true;
                continue;
            }
            this.model_.getComponent(i).ZM(pos, this.rsub(i, m), tmp);
            x.addAY(h, tmp);
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double z = 0.0;
        for (int col = 0; col < this.model_.getComponentsCount(); ++col) {
            double hi = this.model_.getWeight(col, pos);
            if (hi == 0.0) continue;
            ISsf ccmp = this.model_.getComponent(col);
            z += ccmp.ZVZ(pos, this.sub(col, col, vm)) * hi * hi;
            DataBlock zm = new DataBlock(this.tmp_, 0, this.m_dim[col], 1);
            for (int row = col + 1; row < this.model_.getComponentsCount(); ++row) {
                double hj = this.model_.getWeight(row, pos);
                if (hj == 0.0) continue;
                this.model_.getComponent(row).ZM(pos, this.sub(row, col, vm), zm);
                z += 2.0 * hi * hj * ccmp.ZX(pos, zm);
            }
        }
        return z;
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double d = 0.0;
        for (int i = 0; i < this.m_dim.length; ++i) {
            double h = this.model_.getWeight(i, pos);
            if (h == 0.0) continue;
            d += h * this.model_.getComponent(i).ZX(pos, this.sub(i, x));
        }
        return d;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        int j = 0;
        for (int i = 0; i < this.m_dim.length; ++i) {
            int nst = this.model_.getComponent(i).getNonStationaryDim();
            if (nst == 0) continue;
            SubMatrix bi = b.extract(this.m_cdim[i], this.m_dim[i], j, j + nst);
            this.model_.getComponent(i).diffuseConstraints(bi);
            j += nst;
        }
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            this.model_.getComponent(i).fullQ(pos, this.sub(i, i, qm));
        }
    }

    @Override
    public int getNonStationaryDim() {
        int n = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            n += this.model_.getComponent(i).getNonStationaryDim();
        }
        return n;
    }

    @Override
    public int getStateDim() {
        return this.m_fdim;
    }

    @Override
    public int getTransitionResCount() {
        int n = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            n += this.model_.getComponent(i).getTransitionResCount();
        }
        return n;
    }

    @Override
    public int getTransitionResDim() {
        int n = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            n += this.model_.getComponent(i).getTransitionResDim();
        }
        return n;
    }

    @Override
    public boolean hasR() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (!this.model_.getComponent(i).hasR()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (!this.model_.getComponent(i).hasTransitionRes(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasW() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (!this.model_.getComponent(i).hasW()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDiffuse() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (!this.model_.getComponent(i).isDiffuse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        if (!this.model_.hasConstantWeights()) {
            return false;
        }
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).isMeasurementEquationTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        if (!this.model_.hasConstantWeights()) {
            return false;
        }
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).isTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).isTransitionEquationTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).isTransitionResidualTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            this.model_.getComponent(i).Pf0(this.sub(i, i, pf0));
        }
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            this.model_.getComponent(i).Pi0(this.sub(i, i, pi0));
        }
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        int j = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            int rdim = this.model_.getComponent(i).getTransitionResDim();
            if (rdim <= 0) continue;
            this.model_.getComponent(i).Q(pos, qm.extract(j, j + rdim, j, j + rdim));
            j += rdim;
        }
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        int j = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).hasR()) {
                int rcount = this.model_.getComponent(i).getTransitionResCount();
                if (rcount <= 0) continue;
                SubArrayOfInt rvi = rv.range(j, j + rcount);
                this.model_.getComponent(i).R(pos, rvi);
                rvi.add(this.m_cdim[i]);
                j += rcount;
                continue;
            }
            for (int k = 0; k < this.m_dim[k]; ++k) {
                rv.set(j++, this.m_cdim[i] + k);
            }
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            this.model_.getComponent(i).T(pos, this.sub(i, i, tr));
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            this.TX(pos, col);
        } while (cols.next());
        DataBlockIterator rows = vm.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        for (int i = 0; i < this.m_dim.length; ++i) {
            DataBlock xi = this.sub(i, x);
            this.model_.getComponent(i).TX(pos, xi);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.model_.getComponentsCount(); ++i) {
            if (this.model_.getComponent(i).hasW()) {
                int rcount = this.model_.getComponent(i).getTransitionResCount();
                int rdim = this.model_.getComponent(i).getTransitionResDim();
                if (rdim <= 0) continue;
                this.model_.getComponent(i).W(pos, wv.extract(j, j + rcount, k, k + rdim));
                j += rcount;
                k += rdim;
                continue;
            }
            SubMatrix wjj = wv.extract(j, j + this.m_dim[i], k, k + this.m_dim[i]);
            this.model_.getComponent(i).fullQ(pos, wjj);
            j += this.m_dim[i];
            k += this.m_dim[i];
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        for (int i = 0; i < this.m_dim.length; ++i) {
            DataBlock xi = this.sub(i, x);
            this.model_.getComponent(i).XT(pos, xi);
        }
    }

    private SubMatrix sub(int i, int j, SubMatrix m) {
        return m.extract(this.m_cdim[i], this.m_cdim[i] + this.m_dim[i], this.m_cdim[j], this.m_cdim[j] + this.m_dim[j]);
    }

    private SubMatrix rsub(int i, SubMatrix m) {
        return m.extract(this.m_cdim[i], this.m_cdim[i] + this.m_dim[i], 0, m.getColumnsCount());
    }

    private SubMatrix csub(int i, SubMatrix m) {
        return m.extract(0, m.getRowsCount(), this.m_cdim[i], this.m_cdim[i] + this.m_dim[i]);
    }

    private DataBlock sub(int i, DataBlock x) {
        return x.range(this.m_cdim[i], this.m_cdim[i] + this.m_dim[i]);
    }
}

