/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.AsymmetricEndPoints;
import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.FilterFactory;
import ec.satoolkit.x11.IFiltering;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.tstoolkit.maths.linearfilters.FiniteFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;

public class SeasonalFilterFactory {
    public static final SymmetricFilter S3X1 = FilterFactory.makeSymmetricFilter(3, 1);
    public static final SymmetricFilter S3X3 = FilterFactory.makeSymmetricFilter(3, 3);
    public static final SymmetricFilter S3X5 = FilterFactory.makeSymmetricFilter(3, 5);
    public static final SymmetricFilter S3X9 = FilterFactory.makeSymmetricFilter(3, 9);
    public static final SymmetricFilter S3X15 = FilterFactory.makeSymmetricFilter(3, 15);
    private static final double[] ma1x0 = new double[]{0.39, 0.61};
    private static final double[] ma2x1 = new double[]{0.1111111111111111, 0.25925925925925924, 0.37037037037037035, 0.25925925925925924};
    private static final double[] ma2x0 = new double[]{0.18518518518518517, 0.4074074074074074, 0.4074074074074074};
    private static final double[] ma3x2 = new double[]{0.06666666666666667, 0.13333333333333333, 0.21666666666666667, 0.21666666666666667, 0.21666666666666667, 0.15};
    private static final double[] ma3x1 = new double[]{0.06666666666666667, 0.18333333333333332, 0.25, 0.25, 0.25};
    private static final double[] ma3x0 = new double[]{0.15, 0.2833333333333333, 0.2833333333333333, 0.2833333333333333};
    private static final double[] ma5x4 = new double[]{0.034, 0.073, 0.111, 0.113, 0.114, 0.116, 0.117, 0.118, 0.12, 0.084};
    private static final double[] ma5x3 = new double[]{0.034, 0.075, 0.113, 0.117, 0.123, 0.128, 0.132, 0.137, 0.141};
    private static final double[] ma5x2 = new double[]{0.032, 0.079, 0.123, 0.133, 0.143, 0.154, 0.163, 0.173};
    private static final double[] ma5x1 = new double[]{0.028, 0.092, 0.144, 0.16, 0.176, 0.192, 0.208};
    private static final double[] ma5x0 = new double[]{0.051, 0.112, 0.173, 0.197, 0.221, 0.246};
    private static final double[] ma8x0 = new double[]{0.02222, 0.04444, 0.06667, 0.06667, 0.16, 0.16, 0.16, 0.16, 0.16};
    private static final double[] ma8x1 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.14667, 0.14667, 0.14667, 0.14667, 0.14667};
    private static final double[] ma8x2 = new double[]{0.02223, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.13333, 0.13333, 0.13333, 0.13333, 0.13333};
    private static final double[] ma8x3 = new double[]{0.02221, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.12, 0.12, 0.12, 0.12, 0.12};
    private static final double[] ma8x4 = new double[]{0.02219, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.10667, 0.10667, 0.10667, 0.10667, 0.10667};
    private static final double[] ma8x5 = new double[]{0.02222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.09333, 0.09333, 0.09333, 0.09333, 0.09333};
    private static final double[] ma8x6 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.08, 0.08, 0.08, 0.08, 0.08};
    private static final double[] ma8x7 = new double[]{0.0222, 0.04444, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.06667, 0.07111, 0.07111, 0.07111, 0.07111, 0.04889};
    static final FiniteFilter M_1X0 = new FiniteFilter(ma1x0, -1);
    static final FiniteFilter M_2X1 = new FiniteFilter(ma2x1, -2);
    static final FiniteFilter M_2X0 = new FiniteFilter(ma2x0, -2);
    static final FiniteFilter M_3X2 = new FiniteFilter(ma3x2, -3);
    static final FiniteFilter M_3X1 = new FiniteFilter(ma3x1, -3);
    static final FiniteFilter M_3X0 = new FiniteFilter(ma3x0, -3);
    static final FiniteFilter M_5X4 = new FiniteFilter(ma5x4, -5);
    static final FiniteFilter M_5X3 = new FiniteFilter(ma5x3, -5);
    static final FiniteFilter M_5X2 = new FiniteFilter(ma5x2, -5);
    static final FiniteFilter M_5X1 = new FiniteFilter(ma5x1, -5);
    static final FiniteFilter M_5X0 = new FiniteFilter(ma5x0, -5);
    static final FiniteFilter M_8X0 = new FiniteFilter(ma8x0, -8);
    static final FiniteFilter M_8X1 = new FiniteFilter(ma8x1, -8);
    static final FiniteFilter M_8X2 = new FiniteFilter(ma8x2, -8);
    static final FiniteFilter M_8X3 = new FiniteFilter(ma8x3, -8);
    static final FiniteFilter M_8X4 = new FiniteFilter(ma8x4, -8);
    static final FiniteFilter M_8X5 = new FiniteFilter(ma8x5, -8);
    static final FiniteFilter M_8X6 = new FiniteFilter(ma8x6, -8);
    static final FiniteFilter M_8X7 = new FiniteFilter(ma8x7, -8);
    static final FiniteFilter[] FC1 = new FiniteFilter[]{M_1X0};
    static final FiniteFilter[] FC3 = new FiniteFilter[]{M_2X1, M_2X0};
    static final FiniteFilter[] FC5 = new FiniteFilter[]{M_3X2, M_3X1, M_3X0};
    static final FiniteFilter[] FC9 = new FiniteFilter[]{M_5X4, M_5X3, M_5X2, M_5X1, M_5X0};
    static final FiniteFilter[] FC15 = new FiniteFilter[]{M_8X7, M_8X6, M_8X5, M_8X4, M_8X3, M_8X2, M_8X1, M_8X0};
    static final DefaultSeasonalFilteringStrategy C_S3X1 = new DefaultSeasonalFilteringStrategy(S3X1, new AsymmetricEndPoints(FC1), "3x1");
    static final DefaultSeasonalFilteringStrategy C_S3X3 = new DefaultSeasonalFilteringStrategy(S3X3, new AsymmetricEndPoints(FC3), "3x3");
    static final DefaultSeasonalFilteringStrategy C_S3X5 = new DefaultSeasonalFilteringStrategy(S3X5, new AsymmetricEndPoints(FC5), "3x5");
    static final DefaultSeasonalFilteringStrategy C_S3X9 = new DefaultSeasonalFilteringStrategy(S3X9, new AsymmetricEndPoints(FC9), "3x9");
    static final DefaultSeasonalFilteringStrategy C_S3X15 = new DefaultSeasonalFilteringStrategy(S3X15, new AsymmetricEndPoints(FC15), "3x15");

    public static final AsymmetricEndPoints endPoints(int len) {
        switch (len) {
            case 1: {
                return new AsymmetricEndPoints(FC1);
            }
            case 2: {
                return new AsymmetricEndPoints(FC3);
            }
            case 3: {
                return new AsymmetricEndPoints(FC5);
            }
            case 5: {
                return new AsymmetricEndPoints(FC9);
            }
        }
        return null;
    }

    public static DefaultSeasonalFilteringStrategy getDefaultFilteringStrategy(SeasonalFilterOption option) {
        switch (option) {
            case S3X1: {
                return C_S3X1;
            }
            case S3X3: {
                return C_S3X3;
            }
            case S3X5: {
                return C_S3X5;
            }
            case S3X9: {
                return C_S3X9;
            }
            case S3X15: {
                return C_S3X15;
            }
        }
        return null;
    }

    public static IFiltering getFilteringStrategyForGlobalRMS(double rms) {
        if (rms < 2.5) {
            return C_S3X3;
        }
        if (rms >= 2.5 && rms < 3.5) {
            return null;
        }
        if (rms >= 3.5 && rms < 5.5) {
            return C_S3X5;
        }
        if (rms >= 5.5 && rms < 6.5) {
            return null;
        }
        return C_S3X9;
    }
}

