/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.relation;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AEJoinedTableBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AERelationalExprBuilder;
import com.amazon.sqlengine.aeprocessor.aebuilder.relation.AETableNameBuilder;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTIdentifierNode;
import com.amazon.sqlengine.parser.parsetree.PTListNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTListType;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AETableRefBuilder
extends AEBuilderBase<AERelationalExpr> {
    protected AETableRefBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        if (null == aEQueryScope) {
            throw new NullPointerException("Query scope cannot be null.");
        }
    }

    @Override
    public AERelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AERelationalExpr aERelationalExpr = null;
        if (PTNonterminalType.TABLE_REFERENCE == pTNonterminalNode.getNonterminalType()) {
            if (3 != pTNonterminalNode.numChildren()) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CORRELATION_IDENT);
            IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.DERIVED_COLUMN_LIST);
            if (null == iPTNode || null == iPTNode2) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME);
            if (null != iPTNode3) {
                aERelationalExpr = (AERelationalExpr)new AETableNameBuilder(this.getQueryScope()).build(iPTNode3);
            } else {
                IPTNode iPTNode4 = pTNonterminalNode.getChild(PTPositionalType.SUBQUERY);
                if (null == iPTNode4) {
                    throw SQLEngineExceptionFactory.invalidParseTreeException();
                }
                AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(this.getQueryScope(), true);
                AERelationalExpr aERelationalExpr2 = (AERelationalExpr)aERelationalExprBuilder.build(((PTNonterminalNode)iPTNode4).getChild(PTPositionalType.SINGLE_CHILD));
                aERelationalExpr = new AESubQuery(aERelationalExpr2, aERelationalExprBuilder.isQueryCorrelated(), true);
            }
            if (!iPTNode.isEmptyNode()) {
                this.setCorrelationName(iPTNode, iPTNode2, aERelationalExpr);
            }
            this.getQueryScope().addTableSymbol((AENamedRelationalExpr)aERelationalExpr);
        } else {
            aERelationalExpr = (AERelationalExpr)new AEJoinedTableBuilder(this.getQueryScope()).build(pTNonterminalNode);
        }
        assert (null != aERelationalExpr);
        return aERelationalExpr;
    }

    private void setCorrelationName(IPTNode iPTNode, IPTNode iPTNode2, AERelationalExpr aERelationalExpr) throws ErrorException {
        if (!(iPTNode instanceof PTIdentifierNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        ((AENamedRelationalExpr)aERelationalExpr).setCorrelationName(((PTIdentifierNode)iPTNode).getIdentifier());
        if (iPTNode2 instanceof PTListNode) {
            ((AENamedRelationalExpr)aERelationalExpr).overrideColumnNames(this.getRenamedColumnNames((PTListNode)iPTNode2), this.getQueryScope().isCaseSensitive());
        }
    }

    private List<String> getRenamedColumnNames(PTListNode pTListNode) throws ErrorException {
        if (PTListType.COLUMN_NAME_LIST != pTListNode.getListType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        ArrayList<String> arrayList = new ArrayList<String>(pTListNode.numChildren());
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        while (iterator.hasNext()) {
            IPTNode iPTNode = iterator.next();
            if (!(iPTNode instanceof PTIdentifierNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            arrayList.add(((PTIdentifierNode)iPTNode).getIdentifier());
        }
        return arrayList;
    }
}

