/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedVector;

public interface AdaptableVector {
    public ReadableVector getMean();

    public int getUpdateCount();

    public void update(ReadableVector var1);

    public static class AdaptableVariance
    extends Default {
        private final double[] meanSquaredValues;
        private final double[] variance;

        public AdaptableVariance(int n) {
            super(n);
            this.meanSquaredValues = new double[n];
            this.variance = new double[n];
        }

        @Override
        public void update(ReadableVector readableVector) {
            super.update(readableVector);
            for (int i = 0; i < this.dim; ++i) {
                this.meanSquaredValues[i] = (((double)this.updates - 1.0) * this.meanSquaredValues[i] + readableVector.get(i) * readableVector.get(i)) / (double)this.updates;
                this.variance[i] = Math.abs(this.meanSquaredValues[i] - this.getNewMeans(i) * this.getNewMeans(i));
            }
        }

        public double[] getVariance() {
            return (double[])this.variance.clone();
        }
    }

    public static class LimitedMemory
    implements AdaptableVector {
        private final int dim;
        private final double[][] meanQueue;
        private double[] mean;
        private final int queueSize;
        private int updateIndex;
        private int updates;

        public LimitedMemory(int n, int n2) {
            this.dim = n;
            this.queueSize = n2;
            this.meanQueue = new double[n2][n];
            this.mean = new double[n];
            this.updateIndex = 0;
            this.updates = 0;
        }

        @Override
        public ReadableVector getMean() {
            return new WrappedVector.Raw(this.mean);
        }

        @Override
        public int getUpdateCount() {
            return this.updates;
        }

        @Override
        public void update(ReadableVector readableVector) {
            for (int i = 0; i < this.dim; ++i) {
                double d = (readableVector.get(i) - this.meanQueue[this.updateIndex][i]) / (double)this.queueSize;
                int n = i;
                this.mean[n] = this.mean[n] + d;
                this.meanQueue[this.updateIndex][i] = readableVector.get(i);
            }
            ++this.updates;
            this.updateIndex = (this.updateIndex + 1) % this.queueSize;
        }
    }

    public static class Default
    implements AdaptableVector {
        protected final int dim;
        private final double[] oldMeans;
        private final double[] newMeans;
        protected int updates;

        public Default(int n) {
            this.dim = n;
            this.oldMeans = new double[n];
            this.newMeans = new double[n];
            this.updates = 0;
        }

        @Override
        public ReadableVector getMean() {
            return new WrappedVector.Raw(this.newMeans);
        }

        @Override
        public int getUpdateCount() {
            return this.updates;
        }

        @Override
        public void update(ReadableVector readableVector) {
            ++this.updates;
            for (int i = 0; i < this.dim; ++i) {
                this.oldMeans[i] = this.newMeans[i];
                this.newMeans[i] = (this.oldMeans[i] * (double)(this.updates - 1) + readableVector.get(i)) / (double)this.updates;
            }
        }

        public double getOldMeans(int n) {
            return this.oldMeans[n];
        }

        public double getNewMeans(int n) {
            return this.newMeans[n];
        }
    }
}

