/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodelxml.treelikelihood.TreeTraitParserUtilities;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MissingInjection {
    private static final String MISSING_INJECTION = "injectMissingTraits";
    private static final String MISSING_PROBABILITY = "missingProbability";
    private static final String MISSING_COUNT = "maxMissingCount";
    private static final String DIMENSION = "dimension";
    private static final String TRAIT_NAME = "traitName";
    private final List<TaxonInformation> taxonInformation;
    private final String traitName;
    private static final boolean DEBUG = true;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("traitName"), AttributeRule.newDoubleRule("missingProbability"), AttributeRule.newIntegerRule("maxMissingCount", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MissingInjection missingInjection;
            Tree tree = (Tree)xMLObject.getChild(Tree.class);
            String string = xMLObject.getStringAttribute(MissingInjection.TRAIT_NAME);
            double d = xMLObject.getDoubleAttribute(MissingInjection.MISSING_PROBABILITY);
            if (d < 0.0 || d > 1.0) {
                throw new XMLParseException("Must provide a missing probability 0 <= x <= 1");
            }
            int[] nArray = null;
            if (xMLObject.hasAttribute(MissingInjection.DIMENSION)) {
                nArray = MissingInjection.parseVariableLengthIntegerArray(xMLObject.getStringAttribute(MissingInjection.DIMENSION));
            }
            int n = xMLObject.getAttribute(MissingInjection.MISSING_COUNT, Integer.MAX_VALUE);
            try {
                missingInjection = new MissingInjection(tree, string, d, nArray, n);
            }
            catch (TaxonList.MissingAttributeException missingAttributeException) {
                throw new XMLParseException(missingAttributeException.getMessage());
            }
            return missingInjection;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return MissingInjection.class;
        }

        @Override
        public String getParserName() {
            return MissingInjection.MISSING_INJECTION;
        }
    };

    public MissingInjection(Tree tree, String string, double d, int[] nArray, int n) throws TaxonList.MissingAttributeException {
        this.taxonInformation = this.injectMissingValues(string, tree, d, nArray, n);
        this.traitName = string;
    }

    List<TaxonInformation> getTaxonInformation() {
        return this.taxonInformation;
    }

    public String getTraitName() {
        return this.traitName;
    }

    private List<TaxonInformation> injectMissingValues(String string, Tree tree, double d, int[] nArray, int n) throws TaxonList.MissingAttributeException {
        ArrayList<TaxonInformation> arrayList = new ArrayList<TaxonInformation>();
        int n2 = 0;
        int n3 = tree.getTaxonCount();
        while (n2 < n3) {
            Object object;
            String string2 = (String)tree.getTaxonAttribute(n2, string);
            if (string2 == null) {
                object = tree.getTaxonId(n2);
                throw new TaxonList.MissingAttributeException("Trait \"" + string + "\" not found for taxa \"" + (String)object + "\"");
            }
            object = this.injectForOneTaxon(string2, d, nArray, n);
            Taxon taxon = tree.getTaxon(n2);
            taxon.setAttribute(string, ((TaxonInformation)object).newAttribute);
            ((TaxonInformation)object).taxon = taxon;
            ((TaxonInformation)object).index = n2++;
            arrayList.add((TaxonInformation)object);
        }
        return arrayList;
    }

    private TaxonInformation injectForOneTaxon(String string, double d, int[] nArray, int n) {
        ArrayList<InjectedMissingValue> arrayList = new ArrayList<InjectedMissingValue>();
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        for (int i = 0; i < n2; ++i) {
            String string2 = stringTokenizer.nextToken();
            if ((nArray == null || this.inDimension(nArray, i)) && !TreeTraitParserUtilities.isMissing((String)string2) && MathUtils.nextDouble() < d && arrayList.size() < n) {
                System.err.println("Making value " + string2 + " missing.");
                arrayList.add(new InjectedMissingValue(i, new Double(string2)));
                string2 = "?";
            }
            stringBuilder.append(string2).append(" ");
        }
        return new TaxonInformation(arrayList, stringBuilder.toString());
    }

    private static int[] parseVariableLengthIntegerArray(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (arrayList.size() > 0) {
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i) - 1;
            }
            return nArray;
        }
        return null;
    }

    private boolean inDimension(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    class TaxonInformation {
        final List<InjectedMissingValue> injectedMissingValues;
        final String newAttribute;
        int index;
        Taxon taxon;

        TaxonInformation(List<InjectedMissingValue> list, String string) {
            this.injectedMissingValues = list;
            this.newAttribute = string;
        }
    }

    class InjectedMissingValue {
        final int index;
        final double originalValue;

        InjectedMissingValue(int n, double d) {
            this.index = n;
            this.originalValue = d;
        }
    }
}

