/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class VFI
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 8081692166331321866L;
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected Instances m_Instances = null;
    protected double[][][] m_counts;
    protected double[] m_globalCounts;
    protected double[][] m_intervalBounds;
    protected double m_maxEntrop;
    protected boolean m_weightByConfidence = true;
    protected double m_bias = -0.6;
    private double TINY = 1.0E-11;

    public String globalInfo() {
        return "Classification by voting feature intervals. Intervals are constucted around each class for each attribute (basically discretization). Class counts are recorded for each interval on each attribute. Classification is by voting. For more info see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "Have added a simple attribute weighting scheme. Higher weight is " + "assigned to more confident intervals, where confidence is a function " + "of entropy:\nweight (att_i) = (entropy of class distrib att_i / " + "max uncertainty)^-bias";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "G. Demiroz and A. Guvenir");
        result.setValue(TechnicalInformation.Field.TITLE, "Classification by voting feature intervals");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "9th European Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1997");
        result.setValue(TechnicalInformation.Field.PAGES, "85-92");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tDon't weight voting intervals by confidence", "C", 0, "-C"));
        newVector.addElement(new Option("\tSet exponential bias towards confident intervals\n\t(default = 0.6)", "B", 1, "-B <bias>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setWeightByConfidence(!Utils.getFlag('C', options));
        String optionString = Utils.getOption('B', options);
        if (optionString.length() != 0) {
            Double temp = new Double(optionString);
            this.setBias(temp);
        }
        Utils.checkForRemainingOptions(options);
    }

    public String weightByConfidenceTipText() {
        return "Weight feature intervals by confidence";
    }

    public void setWeightByConfidence(boolean c) {
        this.m_weightByConfidence = c;
    }

    public boolean getWeightByConfidence() {
        return this.m_weightByConfidence;
    }

    public String biasTipText() {
        return "Strength of bias towards more confident features";
    }

    public void setBias(double b) {
        this.m_bias = -b;
    }

    public double getBias() {
        return -this.m_bias;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[3];
        int current = 0;
        if (!this.getWeightByConfidence()) {
            options[current++] = "-C";
        }
        options[current++] = "-B";
        options[current++] = "" + this.getBias();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        if (!this.m_weightByConfidence) {
            this.TINY = 0.0;
        }
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_ClassIndex = instances.classIndex();
        this.m_NumClasses = instances.numClasses();
        this.m_globalCounts = new double[this.m_NumClasses];
        this.m_maxEntrop = Math.log(this.m_NumClasses) / Math.log(2.0);
        this.m_Instances = new Instances(instances, 0);
        this.m_intervalBounds = new double[instances.numAttributes()][2 + 2 * this.m_NumClasses];
        int j = 0;
        while (j < instances.numAttributes()) {
            boolean alt = false;
            int i = 0;
            while (i < this.m_NumClasses * 2 + 2) {
                if (i == 0) {
                    this.m_intervalBounds[j][i] = Double.NEGATIVE_INFINITY;
                } else if (i == this.m_NumClasses * 2 + 1) {
                    this.m_intervalBounds[j][i] = Double.POSITIVE_INFINITY;
                } else if (alt) {
                    this.m_intervalBounds[j][i] = Double.NEGATIVE_INFINITY;
                    alt = false;
                } else {
                    this.m_intervalBounds[j][i] = Double.POSITIVE_INFINITY;
                    alt = true;
                }
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < instances.numAttributes()) {
            if (j != this.m_ClassIndex && instances.attribute(j).isNumeric()) {
                int i = 0;
                while (i < instances.numInstances()) {
                    Instance inst = instances.instance(i);
                    if (!inst.isMissing(j)) {
                        if (inst.value(j) < this.m_intervalBounds[j][(int)inst.classValue() * 2 + 1]) {
                            this.m_intervalBounds[j][(int)inst.classValue() * 2 + 1] = inst.value(j);
                        }
                        if (inst.value(j) > this.m_intervalBounds[j][(int)inst.classValue() * 2 + 2]) {
                            this.m_intervalBounds[j][(int)inst.classValue() * 2 + 2] = inst.value(j);
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.m_counts = new double[instances.numAttributes()][][];
        int i = 0;
        while (i < instances.numAttributes()) {
            if (instances.attribute(i).isNumeric()) {
                int[] sortedIntervals = Utils.sort(this.m_intervalBounds[i]);
                int count = 1;
                int j2 = 1;
                while (j2 < sortedIntervals.length) {
                    if (this.m_intervalBounds[i][sortedIntervals[j2]] != this.m_intervalBounds[i][sortedIntervals[j2 - 1]]) {
                        ++count;
                    }
                    ++j2;
                }
                double[] reordered = new double[count];
                count = 1;
                reordered[0] = this.m_intervalBounds[i][sortedIntervals[0]];
                int j3 = 1;
                while (j3 < sortedIntervals.length) {
                    if (this.m_intervalBounds[i][sortedIntervals[j3]] != this.m_intervalBounds[i][sortedIntervals[j3 - 1]]) {
                        reordered[count] = this.m_intervalBounds[i][sortedIntervals[j3]];
                        ++count;
                    }
                    ++j3;
                }
                this.m_intervalBounds[i] = reordered;
                this.m_counts[i] = new double[count][this.m_NumClasses];
            } else if (i != this.m_ClassIndex) {
                this.m_counts[i] = new double[instances.attribute(i).numValues()][this.m_NumClasses];
            }
            ++i;
        }
        i = 0;
        while (i < instances.numInstances()) {
            Instance inst = instances.instance(i);
            int n = (int)instances.instance(i).classValue();
            this.m_globalCounts[n] = this.m_globalCounts[n] + inst.weight();
            int j4 = 0;
            while (j4 < instances.numAttributes()) {
                if (!inst.isMissing(j4) && j4 != this.m_ClassIndex) {
                    if (instances.attribute(j4).isNumeric()) {
                        double val = inst.value(j4);
                        int k = this.m_intervalBounds[j4].length - 1;
                        while (k >= 0) {
                            if (val > this.m_intervalBounds[j4][k]) {
                                double[] dArray = this.m_counts[j4][k];
                                int n2 = (int)inst.classValue();
                                dArray[n2] = dArray[n2] + inst.weight();
                                break;
                            }
                            if (val == this.m_intervalBounds[j4][k]) {
                                double[] dArray = this.m_counts[j4][k];
                                int n3 = (int)inst.classValue();
                                dArray[n3] = dArray[n3] + inst.weight() / 2.0;
                                double[] dArray2 = this.m_counts[j4][k - 1];
                                int n4 = (int)inst.classValue();
                                dArray2[n4] = dArray2[n4] + inst.weight() / 2.0;
                                break;
                            }
                            --k;
                        }
                    } else {
                        double[] dArray = this.m_counts[j4][(int)inst.value(j4)];
                        int n5 = (int)inst.classValue();
                        dArray[n5] = dArray[n5] + inst.weight();
                    }
                }
                ++j4;
            }
            ++i;
        }
    }

    public String toString() {
        if (this.m_Instances == null) {
            return "FVI: Classifier not built yet!";
        }
        StringBuffer sb = new StringBuffer("Voting feature intervals classifier\n");
        return sb.toString();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dist = new double[this.m_NumClasses];
        double[] temp = new double[this.m_NumClasses];
        double weight = 1.0;
        int i = 0;
        while (i < instance.numAttributes()) {
            if (i != this.m_ClassIndex && !instance.isMissing(i)) {
                int j;
                double sum;
                double val = instance.value(i);
                boolean ok = false;
                if (instance.attribute(i).isNumeric()) {
                    int k = this.m_intervalBounds[i].length - 1;
                    while (k >= 0) {
                        int j2;
                        if (val > this.m_intervalBounds[i][k]) {
                            j2 = 0;
                            while (j2 < this.m_NumClasses) {
                                if (this.m_globalCounts[j2] > 0.0) {
                                    temp[j2] = (this.m_counts[i][k][j2] + this.TINY) / (this.m_globalCounts[j2] + this.TINY);
                                }
                                ++j2;
                            }
                            ok = true;
                            break;
                        }
                        if (val == this.m_intervalBounds[i][k]) {
                            j2 = 0;
                            while (j2 < this.m_NumClasses) {
                                if (this.m_globalCounts[j2] > 0.0) {
                                    temp[j2] = (this.m_counts[i][k][j2] + this.m_counts[i][k - 1][j2]) / 2.0 + this.TINY;
                                    int n = j2;
                                    temp[n] = temp[n] / (this.m_globalCounts[j2] + this.TINY);
                                }
                                ++j2;
                            }
                            ok = true;
                            break;
                        }
                        --k;
                    }
                    if (!ok) {
                        throw new Exception("This shouldn't happen");
                    }
                } else {
                    ok = true;
                    int j3 = 0;
                    while (j3 < this.m_NumClasses) {
                        if (this.m_globalCounts[j3] > 0.0) {
                            temp[j3] = (this.m_counts[i][(int)val][j3] + this.TINY) / (this.m_globalCounts[j3] + this.TINY);
                        }
                        ++j3;
                    }
                }
                if ((sum = Utils.sum(temp)) <= 0.0) {
                    j = 0;
                    while (j < temp.length) {
                        temp[j] = 1.0 / (double)temp.length;
                        ++j;
                    }
                } else {
                    Utils.normalize(temp, sum);
                }
                if (this.m_weightByConfidence) {
                    weight = ContingencyTables.entropy(temp);
                    if ((weight = Math.pow(weight, this.m_bias)) < 1.0) {
                        weight = 1.0;
                    }
                }
                j = 0;
                while (j < this.m_NumClasses) {
                    int n = j;
                    dist[n] = dist[n] + temp[j] * weight;
                    ++j;
                }
            }
            ++i;
        }
        double sum = Utils.sum(dist);
        if (sum <= 0.0) {
            int j = 0;
            while (j < dist.length) {
                dist[j] = 1.0 / (double)dist.length;
                ++j;
            }
            return dist;
        }
        Utils.normalize(dist, sum);
        return dist;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7180 $");
    }

    public static void main(String[] args) {
        VFI.runClassifier(new VFI(), args);
    }
}

