/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima.estimation;

import internal.toolkit.base.core.arima.AnsleyFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.ElementaryTransformations;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;

public class McElroyEstimates {
    private UcarimaModel ucm_;
    private double[] data_;
    private FastMatrix[] M_;
    private FastMatrix[] F_;
    private FastMatrix[] L_;
    private FastMatrix[] K_;
    private FastMatrix[] D_;
    private double[][] cmps_;
    private double[][] fcmps_;
    private int nf_;
    private ArmaFilter[] filters_;

    private void clear() {
        this.M_ = null;
        this.F_ = null;
        this.L_ = null;
        this.K_ = null;
        this.cmps_ = null;
        this.filters_ = null;
        this.D_ = null;
        this.fcmps_ = null;
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm_;
    }

    public void setUcarimaModel(UcarimaModel ucm) {
        this.ucm_ = ucm;
        this.clear();
    }

    public void setData(DoubleSeq data) {
        this.data_ = data.toArray();
        this.clear();
    }

    public void setData(double[] data) {
        this.data_ = data;
        this.clear();
    }

    public double[] getData() {
        return this.data_;
    }

    public int getForecastsCount() {
        return this.nf_;
    }

    public void setForecastsCount(int nf) {
        if (nf != this.nf_) {
            this.nf_ = nf;
            this.D_ = null;
            this.fcmps_ = null;
        }
    }

    public double[] getComponent(int cmp) {
        this.calc(cmp);
        return this.cmps_[cmp];
    }

    public double[] getForecasts(int cmp) {
        this.fcalc(cmp);
        return this.fcmps_[cmp];
    }

    public double[] getForecasts() {
        int n = this.ucm_.getComponentsCount();
        this.fcalc(n);
        return this.fcmps_[n];
    }

    public double[] stdevForecasts() {
        int n = this.ucm_.getComponentsCount();
        return this.stdevForecasts(n);
    }

    public double[] stdevForecasts(int cmp) {
        this.fcalc(cmp);
        FastMatrix m = this.D_[cmp];
        DataBlock var = m.diagonal();
        double[] e = new double[var.length()];
        var.copyTo(e, 0);
        for (int i = 0; i < e.length; ++i) {
            e[i] = Math.sqrt(e[i]);
        }
        return e;
    }

    public double[] stdevEstimates(int cmp) {
        FastMatrix m = this.M(cmp);
        DataBlock var = m.diagonal();
        double[] e = new double[var.length()];
        var.copyTo(e, 0);
        for (int i = 0; i < e.length; ++i) {
            e[i] = Math.sqrt(e[i]);
        }
        return e;
    }

    public FastMatrix M(int cmp) {
        this.calc(cmp);
        if (this.M_[cmp] == null) {
            FastMatrix L = this.L_[cmp];
            if (L == null) {
                return null;
            }
            FastMatrix I = FastMatrix.identity(L.getColumnsCount());
            LowerTriangularMatrix.solveXL(L, I);
            LowerTriangularMatrix.solveLX(L, I);
            this.M_[cmp] = I;
        }
        return this.M_[cmp];
    }

    public FastMatrix F(int cmp) {
        this.calc(cmp);
        if (this.F_[cmp] == null) {
            FastMatrix L = this.L_[cmp];
            FastMatrix K = this.K_[cmp];
            if (L == null || K == null) {
                return null;
            }
            FastMatrix KK = SymmetricMatrix.XtX(K);
            LowerTriangularMatrix.solveLX(L, KK);
            LowerTriangularMatrix.solveLtX(L, KK);
            this.F_[cmp] = KK;
        }
        return this.F_[cmp];
    }

    private void calc(int cmp) {
        int i;
        DataBlock d;
        int j;
        if (this.data_ == null || this.ucm_ == null) {
            return;
        }
        if (this.M_ == null) {
            int ncmps = this.ucm_.getComponentsCount();
            this.K_ = new FastMatrix[ncmps];
            this.L_ = new FastMatrix[ncmps];
            this.M_ = new FastMatrix[ncmps];
            this.F_ = new FastMatrix[ncmps];
            this.cmps_ = new double[ncmps][];
            this.filters_ = new ArmaFilter[ncmps + 1];
        } else if (this.cmps_[cmp] != null) {
            return;
        }
        ArimaModel signal = this.ucm_.getComponent(cmp);
        if (signal.isNull()) {
            return;
        }
        ArimaModel noise = this.ucm_.getComplement(cmp);
        int n = this.data_.length;
        StationaryTransformation<ArimaModel> stS = signal.stationaryTransformation();
        StationaryTransformation<ArimaModel> stN = noise.stationaryTransformation();
        Polynomial ds = stS.getUnitRoots().asPolynomial();
        Polynomial dn = stN.getUnitRoots().asPolynomial();
        FastMatrix DS = FastMatrix.make(n - ds.degree(), n);
        FastMatrix DN = FastMatrix.make(n - dn.degree(), n);
        double[] c = ds.toArray();
        for (j = 0; j < c.length; ++j) {
            d = DS.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        c = dn.toArray();
        for (j = 0; j < c.length; ++j) {
            d = DN.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        AnsleyFilter S = new AnsleyFilter();
        S.prepare(stS.getStationaryModel(), n - ds.degree());
        this.filters_[cmp] = S;
        AnsleyFilter N = new AnsleyFilter();
        N.prepare(stN.getStationaryModel(), n - dn.degree());
        FastMatrix Q = FastMatrix.make(n, 2 * n - ds.degree() - dn.degree());
        for (i = 0; i < n; ++i) {
            S.apply((DoubleSeq)DS.column(i), Q.row(n - i - 1).range(0, n - ds.degree()));
        }
        for (i = 0; i < n; ++i) {
            N.apply((DoubleSeq)DN.column(i), Q.row(n - i - 1).drop(n - ds.degree(), 0));
        }
        this.K_[cmp] = Q.extract(0, n, n - ds.degree(), Q.getColumnsCount() - n + ds.degree()).deepClone();
        DataBlock yd = DataBlock.make(n - dn.degree());
        noise.getNonStationaryAr().apply(DataBlock.of(this.data_), yd);
        DataBlock yl = DataBlock.make(yd.length());
        N.apply((DoubleSeq)yd, yl);
        double[] z = new double[n];
        int i2 = 0;
        int j2 = n - 1;
        while (i2 < n) {
            z[i2] = Q.row(j2).drop(n - ds.degree(), 0).dot(yl);
            ++i2;
            --j2;
        }
        ElementaryTransformations.fastGivensTriangularize(Q);
        FastMatrix L = Q.extract(0, n, 0, n).deepClone();
        LowerTriangularMatrix.solveLx(L, DataBlock.of(z));
        LowerTriangularMatrix.solvexL(L, DataBlock.of(z));
        this.L_[cmp] = L;
        this.cmps_[cmp] = z;
    }

    private ArmaFilter seriesFilter() {
        int n = this.data_.length;
        IArimaModel model = this.ucm_.getModel();
        StationaryTransformation stm = model.stationaryTransformation();
        AnsleyFilter F2 = new AnsleyFilter();
        F2.prepare((IArimaModel)stm.getStationaryModel(), n - stm.getUnitRoots().getDegree());
        return F2;
    }

    private void fcalc(int cmp) {
        FastMatrix D;
        IArimaModel signal;
        boolean fs;
        int ncmps = this.ucm_.getComponentsCount();
        boolean bl = fs = cmp == ncmps;
        if (!fs) {
            this.calc(cmp);
        }
        if (this.fcmps_ == null) {
            this.fcmps_ = new double[ncmps + 1][];
            this.D_ = new FastMatrix[ncmps + 1];
        } else if (this.fcmps_[cmp] != null) {
            return;
        }
        if (fs) {
            if (this.filters_ == null) {
                this.filters_ = new ArmaFilter[ncmps + 1];
            }
            if (this.filters_[cmp] == null) {
                this.filters_[cmp] = this.seriesFilter();
            }
        }
        int n = this.data_.length;
        IArimaModel iArimaModel = signal = fs ? this.ucm_.getModel() : this.ucm_.getComponent(cmp);
        if (signal.isNull()) {
            return;
        }
        StationaryTransformation stS = signal.stationaryTransformation();
        Polynomial ds = stS.getUnitRoots().asPolynomial();
        FastMatrix DS = FastMatrix.make(n - ds.degree(), n);
        double[] c = ds.toArray();
        for (int j = 0; j < c.length; ++j) {
            DataBlock d = DS.subDiagonal(j);
            d.set(c[c.length - j - 1]);
        }
        FastMatrix Q = FastMatrix.make(n - ds.degree(), n);
        for (int i = 0; i < n; ++i) {
            this.filters_[cmp].apply((DoubleSeq)DS.column(i), Q.column(i));
        }
        FastMatrix U = FastMatrix.make(n - ds.degree(), this.nf_);
        double[] acf = stS.getStationaryModel().getAutoCovarianceFunction().values(n - ds.degree() + this.nf_);
        for (int i = 0; i < this.nf_; ++i) {
            U.column(i).reverse().copyFrom(acf, i + 1);
        }
        FastMatrix V = FastMatrix.make(this.nf_, n - ds.degree());
        for (int i = 0; i < this.nf_; ++i) {
            if (U.column(i).allMatch(x -> Math.abs(x) < 1.0E-6)) continue;
            this.filters_[cmp].apply((DoubleSeq)U.column(i), V.row(i));
        }
        FastMatrix W = GeneralMatrix.AB(V, Q);
        if (ds.degree() > 0) {
            D = FastMatrix.make(ds.degree() + this.nf_, n);
            D.subDiagonal(n - ds.degree()).set(1.0);
            D.extract(ds.degree(), D.getRowsCount(), 0, n).copy(W);
            FastMatrix S = FastMatrix.make(ds.degree() + this.nf_, ds.degree() + this.nf_);
            S.diagonal().set(1.0);
            for (int i = 1; i <= ds.degree(); ++i) {
                S.subDiagonal(-i).drop(ds.degree() - i, 0).set(ds.get(i));
            }
            LowerTriangularMatrix.solveLX(S, D);
            D = D.extract(ds.degree(), D.getRowsCount() - ds.degree(), 0, n).deepClone();
        } else {
            D = W;
        }
        DataBlock f = DataBlock.make(this.nf_);
        double[] data = fs ? this.data_ : this.getComponent(cmp);
        f.product(D.rowsIterator(), DataBlock.of(data));
        this.fcmps_[cmp] = f.getStorage();
        FastMatrix G = SymmetricMatrix.XXt(V);
        G.chs();
        G.diagonal().add(acf[0]);
        for (int i = 1; i < this.nf_; ++i) {
            G.subDiagonal(i).add(acf[i]);
            G.subDiagonal(-i).add(acf[i]);
        }
        if (ds.degree() > 0) {
            FastMatrix B = FastMatrix.square(this.nf_);
            RationalFunction rfe = RationalFunction.of(Polynomial.ONE, ds);
            double[] coeff = rfe.coefficients(this.nf_);
            for (int i = 0; i < this.nf_; ++i) {
                B.subDiagonal(-i).set(coeff[i]);
            }
            G = SymmetricMatrix.XSXt(G, B);
        }
        if (!fs) {
            FastMatrix m = this.M(cmp);
            m = SymmetricMatrix.XSXt(m, D);
            G.add(m);
        }
        this.D_[cmp] = G;
    }
}

