/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import jdplus.toolkit.base.core.ssf.basic.Measurements;
import jdplus.toolkit.base.core.ssf.basic.MeasurementsError;
import jdplus.toolkit.base.core.ssf.composite.ComplexLoading;
import jdplus.toolkit.base.core.ssf.composite.CompositeDynamics;
import jdplus.toolkit.base.core.ssf.composite.CompositeInitialization;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;
import jdplus.toolkit.base.core.ssf.multivariate.M2uAdapter;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateSsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MultivariateCompositeSsf
extends MultivariateSsf {
    private final int[] pos;
    private int[] dim;

    private MultivariateCompositeSsf(int[] pos, int[] dim, ISsfInitialization initializer, ISsfDynamics dynamics, ISsfMeasurements measurements) {
        super(initializer, dynamics, measurements);
        this.pos = pos;
        this.dim = dim;
    }

    public ISsf asSsf() {
        return M2uAdapter.of(this);
    }

    public int[] componentsPosition() {
        return (int[])this.pos.clone();
    }

    public int[] componentsDimension() {
        return (int[])this.dim.clone();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<StateComponent> components = new ArrayList<StateComponent>();
        private final List<ISsfLoading> defLoadings = new ArrayList<ISsfLoading>();
        private final List<String> names = new ArrayList<String>();
        private final List<Equation> equations = new ArrayList<Equation>();
        private ISsfErrors measurementsError;

        public Builder add(String name, StateComponent cmp, ISsfLoading loading) {
            this.components.add(new StateComponent(cmp.initialization(), cmp.dynamics()));
            this.defLoadings.add(loading);
            this.names.add(name);
            return this;
        }

        public Builder add(Equation equation) {
            this.equations.add(equation);
            return this;
        }

        public Builder measurementError(ISsfErrors measurementsError) {
            this.measurementsError = measurementsError;
            return this;
        }

        public MultivariateCompositeSsf build() {
            if (this.components.isEmpty() || this.equations.isEmpty()) {
                return null;
            }
            int n = this.components.size();
            int neq = this.equations.size();
            int[] dim = new int[n];
            int[] pos = new int[n];
            ISsfInitialization[] i = new ISsfInitialization[n];
            ISsfDynamics[] d = new ISsfDynamics[n];
            int cpos = 0;
            for (int j = 0; j < n; ++j) {
                StateComponent cur = this.components.get(j);
                i[j] = cur.initialization();
                d[j] = cur.dynamics();
                pos[j] = cpos;
                dim[j] = i[j].getStateDim();
                cpos += dim[j];
            }
            ISsfErrors errors = this.measurementsError;
            if (errors == null) {
                errors = MeasurementsError.of(DoubleSeq.onMapping((int)neq, k -> this.equations.get(k).getMeasurementError()));
            }
            ISsfLoading[] loadings = new ISsfLoading[neq];
            for (int j = 0; j < neq; ++j) {
                loadings[j] = Loading.optimize(this.loadingOf(this.equations.get(j), pos, dim), cpos);
            }
            return new MultivariateCompositeSsf(pos, dim, new CompositeInitialization(dim, i), new CompositeDynamics(dim, d), Measurements.of(loadings, errors));
        }

        private ISsfLoading loadingOf(Equation eq, int[] pos, int[] dim) {
            int[] c = this.cmpOf(eq);
            int[] npos = new int[c.length];
            int[] ndim = new int[c.length];
            ISsfLoading[] loadings = new ISsfLoading[c.length];
            for (int j = 0; j < c.length; ++j) {
                Item item = eq.items.get(j);
                ISsfLoading curloading = item.loading;
                if (curloading == null) {
                    curloading = this.defLoadings.get(c[j]);
                }
                loadings[j] = Loading.rescale(curloading, item.coefficient);
                npos[j] = pos[c[j]];
                ndim[j] = dim[c[j]];
            }
            return new ComplexLoading(npos, ndim, loadings);
        }

        private int[] cmpOf(Equation eq) {
            int[] c = new int[eq.items.size()];
            for (int i = 0; i < c.length; ++i) {
                c[i] = this.cmp(eq.items.get((int)i).component);
            }
            return c;
        }

        private int cmp(String name) {
            int c = this.names.indexOf(name);
            if (c < 0) {
                throw new SsfException("Invalid model definition");
            }
            return c;
        }
    }

    public static final class Equation {
        private final List<Item> items = new ArrayList<Item>();
        private final double measurementError;

        public void add(Item item) {
            this.items.add(item);
        }

        @Generated
        public Equation(double measurementError) {
            this.measurementError = measurementError;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public double getMeasurementError() {
            return this.measurementError;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Equation)) {
                return false;
            }
            Equation other = (Equation)o;
            if (Double.compare(this.getMeasurementError(), other.getMeasurementError()) != 0) {
                return false;
            }
            List<Item> this$items = this.getItems();
            List<Item> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $measurementError = Double.doubleToLongBits(this.getMeasurementError());
            result = result * 59 + (int)($measurementError >>> 32 ^ $measurementError);
            List<Item> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "MultivariateCompositeSsf.Equation(items=" + String.valueOf(this.getItems()) + ", measurementError=" + this.getMeasurementError() + ")";
        }
    }

    public static final class Item {
        private final String component;
        private final double coefficient;
        private final ISsfLoading loading;

        public Item(String component, double coefficient, ISsfLoading loading) {
            this.component = component;
            this.coefficient = coefficient;
            this.loading = loading;
        }

        @Generated
        public String getComponent() {
            return this.component;
        }

        @Generated
        public double getCoefficient() {
            return this.coefficient;
        }

        @Generated
        public ISsfLoading getLoading() {
            return this.loading;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (Double.compare(this.getCoefficient(), other.getCoefficient()) != 0) {
                return false;
            }
            String this$component = this.getComponent();
            String other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            ISsfLoading this$loading = this.getLoading();
            ISsfLoading other$loading = other.getLoading();
            return !(this$loading == null ? other$loading != null : !this$loading.equals(other$loading));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $coefficient = Double.doubleToLongBits(this.getCoefficient());
            result = result * 59 + (int)($coefficient >>> 32 ^ $coefficient);
            String $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            ISsfLoading $loading = this.getLoading();
            result = result * 59 + ($loading == null ? 43 : $loading.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "MultivariateCompositeSsf.Item(component=" + this.getComponent() + ", coefficient=" + this.getCoefficient() + ", loading=" + String.valueOf(this.getLoading()) + ")";
        }
    }
}

