/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.internal;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regsarima.IArmaInitializer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.HannanRissanen;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class HannanRissanenInitializer
implements IArmaInitializer {
    private static final double EPS = 1.0E-9;
    private final boolean usedefault;
    private final boolean stabilize;
    private final boolean failifunstable;
    private DoubleSeq dy_;

    public boolean isStabilizing() {
        return this.stabilize;
    }

    public boolean isUsingDefaultIfFailed() {
        return this.usedefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    private HannanRissanenInitializer(boolean stabilize, boolean usedefault, boolean failifunstable) {
        this.stabilize = stabilize;
        this.usedefault = usedefault;
        this.failifunstable = failifunstable;
    }

    @Override
    public SarimaModel initialize(RegArmaModel<SarimaModel> regs) {
        SarimaModel sarima = regs.getArma();
        SarimaOrders spec = sarima.orders();
        SarmaOrders dspec = spec.doStationary();
        try {
            if (spec.getParametersCount() == 0) {
                return SarimaModel.builder(dspec).build();
            }
            this.dy_ = null;
            LinearModel lm = regs.asLinearModel();
            HannanRissanen hr = HannanRissanen.builder().build();
            if (lm.getVariablesCount() > 0) {
                LeastSquaresResults lsr = Ols.compute(lm);
                this.dy_ = lm.calcResiduals(lsr.getCoefficients());
            } else {
                this.dy_ = lm.getY();
            }
            if (Math.sqrt(this.dy_.ssq() / (double)this.dy_.length()) < 1.0E-9) {
                return SarimaModel.builder(spec).setDefault(0.0, 0.0).build();
            }
            if (!hr.process(this.dy_, dspec)) {
                if (this.usedefault) {
                    return SarimaModel.builder(spec).setDefault().build();
                }
                return null;
            }
            SarimaModel m = hr.getModel();
            if (!this.stabilize) {
                return m;
            }
            SarimaModel nm = SarimaMapping.stabilize(m);
            if (nm != m && this.failifunstable) {
                return null;
            }
            return nm;
        }
        catch (Exception ex) {
            if (this.usedefault) {
                return SarimaModel.builder(spec).setDefault().build();
            }
            return null;
        }
    }

    public static class Builder {
        private boolean usedefault;
        private boolean stabilize;
        private boolean failifunstable;

        public Builder useDefaultIfFailed(boolean usedefault) {
            this.usedefault = usedefault;
            return this;
        }

        public Builder stabilize(boolean stabilize) {
            this.stabilize = stabilize;
            return this;
        }

        public Builder failIfUnstable(boolean failifunstable) {
            this.failifunstable = failifunstable;
            if (failifunstable) {
                this.stabilize = true;
            }
            return this;
        }

        public HannanRissanenInitializer build() {
            return new HannanRissanenInitializer(this.stabilize, this.usedefault, this.failifunstable);
        }
    }
}

