/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class ParetoMaximizer
extends Propagator<IntVar>
implements IMonitorSolution {
    private final LinkedList<Solution> paretoSolutions;
    private final LinkedList<int[]> paretoFront;
    private final Model model;
    private final LinkedList<Solution> poolSols = new LinkedList();
    private final IntVar[] objectives;
    private final int n;

    public ParetoMaximizer(IntVar[] objectives) {
        super((Variable[])objectives, (Priority)PropagatorPriority.QUADRATIC, false);
        this.paretoSolutions = new LinkedList();
        this.paretoFront = new LinkedList();
        this.objectives = (IntVar[])objectives.clone();
        this.n = objectives.length;
        this.model = objectives[0].getModel();
    }

    public List<Solution> getParetoFront() {
        return this.paretoSolutions;
    }

    @Override
    public void onSolution() {
        int[] vals = Stream.of(this.objectives).mapToInt(IntVar::getValue).toArray();
        for (int i = this.paretoFront.size() - 1; i >= 0; --i) {
            if (!this.isDominated(this.paretoSolutions.get(i), vals)) continue;
            this.poolSols.add(this.paretoSolutions.remove(i));
            this.paretoFront.remove(i);
        }
        Solution solution = this.poolSols.isEmpty() ? new Solution(this.model, new Variable[0]) : this.poolSols.remove();
        solution.record();
        this.paretoSolutions.add(solution);
        this.paretoFront.add(vals);
    }

    private boolean isDominated(Solution solution, int[] vals) {
        for (int i = 0; i < this.n; ++i) {
            int delta = solution.getIntVal(this.objectives[i]) - vals[i];
            if (delta <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.objectives.length; ++i) {
            this.computeTightestPoint(i);
        }
    }

    private void computeTightestPoint(int i) throws ContradictionException {
        int tightestPoint = Integer.MIN_VALUE;
        int[] dominatedPoint = this.computeDominatedPoint(i);
        for (int[] sol : this.paretoFront) {
            int currentPoint;
            int dominates = this.dominates(sol, dominatedPoint, i);
            if (dominates <= 0 || tightestPoint >= (currentPoint = dominates == 1 ? sol[i] : sol[i] + 1)) continue;
            tightestPoint = currentPoint;
        }
        if (tightestPoint > Integer.MIN_VALUE) {
            this.objectives[i].updateLowerBound(tightestPoint, (ICause)this);
        }
    }

    private int[] computeDominatedPoint(int i) {
        int[] dp = Stream.of(this.objectives).mapToInt(IntVar::getUB).toArray();
        dp[i] = this.objectives[i].getLB();
        return dp;
    }

    private int dominates(int[] a2, int[] b, int i) {
        int dominates = 0;
        for (int j = 0; j < this.objectives.length; ++j) {
            if (a2[j] < b[j]) {
                return 0;
            }
            if (a2[j] <= b[j]) continue;
            if (dominates == 0) {
                dominates = 1;
            }
            if (j == i) continue;
            dominates = 2;
        }
        return dominates;
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

