/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class PropIntBoundedMemberSet
extends Propagator<Variable> {
    private final IntVar iv;
    private final SetVar set;

    public PropIntBoundedMemberSet(SetVar setVar, IntVar intVar) {
        super(new Variable[]{setVar, intVar}, (Priority)PropagatorPriority.BINARY, false);
        assert (!intVar.hasEnumeratedDomain());
        this.set = (SetVar)this.vars[0];
        this.iv = (IntVar)this.vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.iv.isInstantiated()) {
            this.set.force(this.iv.getValue(), this);
            this.setPassive();
        } else {
            ISet ub = this.set.getUB();
            if (ub.size() == 0) {
                this.fails();
            } else {
                if (ub.contains(this.iv.getLB()) && ub.contains(this.iv.getUB())) {
                    return;
                }
                this.iv.updateBounds(ub.min(), ub.max(), this);
                if (this.iv.isInstantiated()) {
                    this.set.force(this.iv.getValue(), this);
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        if (this.iv.isInstantiated()) {
            if (!this.set.getUB().contains(this.iv.getValue())) {
                return ESat.FALSE;
            }
            if (this.set.getLB().contains(this.iv.getValue())) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        int lb = this.iv.getLB();
        int ub = this.iv.getUB();
        boolean all = true;
        for (i = lb; i <= ub; ++i) {
            if (this.set.getLB().contains(i)) continue;
            all = false;
            break;
        }
        if (all) {
            return ESat.TRUE;
        }
        for (i = lb; i <= ub; ++i) {
            if (!this.set.getUB().contains(i)) continue;
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }
}

