/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.reification.PropLocalConDis;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class LocalConstructiveDisjunction
extends Constraint {
    public LocalConstructiveDisjunction(Constraint ... constraints) {
        super("LOCALCONSTRUCTIVEDISJUNCTION", LocalConstructiveDisjunction.createProps(constraints));
    }

    private static Propagator[] createProps(Constraint ... constraints) {
        Propagator[][] propagators = new Propagator[constraints.length][];
        TIntObjectHashMap<IntVar> map1 = new TIntObjectHashMap<IntVar>();
        for (int i = 0; i < constraints.length; ++i) {
            propagators[i] = (Propagator[])constraints[i].getPropagators().clone();
            for (int j = 0; j < propagators[i].length; ++j) {
                Propagator prop = propagators[i][j];
                prop.setReifiedSilent(null);
                for (int k = 0; k < prop.getNbVars(); ++k) {
                    map1.put(((IntVar)prop.getVar(k)).getId(), (IntVar)prop.getVar(k));
                }
            }
        }
        int[] keys = map1.keys();
        Arrays.sort(keys);
        IntVar[] allvars = new IntVar[keys.length];
        int k = 0;
        for (int i = 0; i < keys.length; ++i) {
            allvars[k++] = (IntVar)map1.get(keys[i]);
        }
        IntVar[] vars = Arrays.copyOf(allvars, k);
        assert (vars.length > 0);
        return ArrayUtils.append({new PropLocalConDis(vars, propagators)}, ArrayUtils.flatten(propagators));
    }

    @Override
    public ESat isSatisfied() {
        return this.propagators[0].isEntailed();
    }
}

